/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block.plant;

import com.crypticmushroom.minecraft.midnight.common.block.plant.CustomPlaceableBush;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class MnDoublePlantBlock
extends DoublePlantBlock
implements CustomPlaceableBush {
    private final TagKey<Block> plantableBlocks;
    private final boolean requireSolidFace;
    private final VoxelShape hitboxLower;
    private final VoxelShape hitboxUpper;

    public MnDoublePlantBlock(BlockBehaviour.Properties properties, TagKey<Block> plantableBlocks, boolean requireSolidFace) {
        this(properties, plantableBlocks, requireSolidFace, Shapes.m_83144_(), Shapes.m_83144_());
    }

    public MnDoublePlantBlock(BlockBehaviour.Properties properties, TagKey<Block> plantableBlocks, boolean requireSolidFace, double size, double height) {
        this(properties, plantableBlocks, requireSolidFace, MnDoublePlantBlock.getHitboxLower(size, height), MnDoublePlantBlock.getHitboxUpper(size, height));
    }

    public MnDoublePlantBlock(BlockBehaviour.Properties properties, TagKey<Block> plantableBlocks, boolean requireSolidFace, VoxelShape lowerHitbox, VoxelShape upperHitbox) {
        super(properties);
        this.plantableBlocks = plantableBlocks;
        this.requireSolidFace = requireSolidFace;
        this.hitboxLower = lowerHitbox;
        this.hitboxUpper = upperHitbox;
    }

    @Override
    public TagKey<Block> getPlantableBlocks() {
        return this.plantableBlocks;
    }

    @Override
    public boolean requiresSolidFace() {
        return this.requireSolidFace;
    }

    private static VoxelShape getHitboxLower(double size, double height) {
        double radius = size / 2.0;
        return Block.m_49796_((double)(8.0 - radius), (double)0.0, (double)(8.0 - radius), (double)(8.0 + radius), (double)Math.min(height, 16.0), (double)(8.0 + radius));
    }

    private static VoxelShape getHitboxUpper(double size, double height) {
        double radius = size / 2.0;
        return height < 16.0 ? Shapes.m_83040_() : Block.m_49796_((double)(8.0 - radius), (double)0.0, (double)(8.0 - radius), (double)(8.0 + radius), (double)(height - 16.0), (double)(8.0 + radius));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        Vec3 off = state.m_60824_(level, pos);
        return (state.m_61143_((Property)f_52858_) == DoubleBlockHalf.LOWER ? this.hitboxLower : this.hitboxUpper).m_83216_(off.f_82479_, off.f_82480_, off.f_82481_);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }
}

