/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.common.block;

import com.crypticmushroom.minecraft.midnight.common.advancement.MnCriteriaTriggers;
import com.crypticmushroom.minecraft.midnight.common.registry.MnEntityTypes;
import com.crypticmushroom.minecraft.midnight.common.util.MathUtil;
import com.crypticmushroom.minecraft.registry.api.block.MakesCustomBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;

public abstract class NestedEggsBlock
extends Block
implements MakesCustomBlockItem<ItemNameBlockItem> {
    private static final VoxelShape BOUND_ONE_EGG = Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);
    private static final VoxelShape BOUND_SEVERAL_EGGS = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0);
    public static final IntegerProperty EGGS = BlockStateProperties.f_61415_;

    protected NestedEggsBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)EGGS, (Comparable)Integer.valueOf(1)));
    }

    protected abstract void spawnEntity(ServerLevel var1, BlockPos var2, BlockState var3);

    protected float getSpawnChance(Level level, BlockPos pos) {
        return switch (level.m_6436_(pos).m_19048_()) {
            default -> throw new IncompatibleClassChangeError();
            case Difficulty.PEACEFUL -> 0.25f;
            case Difficulty.EASY -> 0.75f;
            case Difficulty.NORMAL -> 0.9f;
            case Difficulty.HARD -> 1.0f;
        };
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_().equals(this.m_5456_())) {
            if ((Integer)state.m_61143_((Property)EGGS) < 4 && !player.m_9236_().f_46443_) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)EGGS) + 1)));
                level.m_5594_(null, pos, this.f_60446_.m_56777_(), SoundSource.BLOCKS, (this.f_60446_.m_56773_() + 1.0f) / 2.0f, this.f_60446_.m_56774_() * 0.8f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_141947_(Level level, BlockPos pos, BlockState state, Entity entity) {
        super.m_141947_(level, pos, state, entity);
        this.attemptTrample(level, entity, pos, 0.05f);
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(level, state, pos, entity, fallDistance);
        this.attemptTrample(level, entity, pos, 1.0f);
    }

    private void attemptTrample(Level level, Entity entity, BlockPos pos, float chance) {
        boolean canTrample;
        boolean bl = canTrample = entity instanceof Player || entity instanceof LivingEntity && !entity.m_6095_().equals(MnEntityTypes.STINGER.get()) && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)entity);
        if (level.f_46443_ || !MathUtil.chanceMet(level, chance) || !canTrample) {
            return;
        }
        this.breakEggs(level, pos, level.m_8055_(pos), entity);
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity blockEntity, ItemStack tool) {
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
        float chance = (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0 ? 0.6f : 0.2f) + 0.1f * (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)tool);
        if (chance >= level.f_46441_.m_188501_()) {
            Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)this.m_5456_().m_7968_());
        }
        this.breakEggs(level, pos, state, (Entity)player);
    }

    protected boolean breakEggs(Level level, BlockPos pos, BlockState state, Entity entity) {
        if (level.f_46443_ || !(state.m_60734_() instanceof NestedEggsBlock)) {
            return false;
        }
        level.m_5594_(null, pos, this.f_60446_.m_56775_(), SoundSource.BLOCKS, 0.7f, 0.9f + level.f_46441_.m_188501_() * 0.2f);
        int eggs = (Integer)state.m_61143_((Property)EGGS);
        if (eggs <= 1) {
            level.m_46961_(pos, false);
        } else {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)EGGS, (Comparable)Integer.valueOf(--eggs)), 2);
            level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
        }
        if (MathUtil.chanceMet(level, this.getSpawnChance(level, pos))) {
            this.spawnEntity((ServerLevel)level, pos, state);
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                MnCriteriaTriggers.BREAK_EGGS.m_222618_(serverPlayer);
            }
        }
        return true;
    }

    public boolean m_5946_(BlockState state, Fluid fluid) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)EGGS) > 1 ? BOUND_SEVERAL_EGGS : BOUND_ONE_EGG;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{EGGS});
    }

    public ItemNameBlockItem cmreg$makeBlockItem(Item.Properties properties) {
        return new ItemNameBlockItem((Block)this, properties);
    }
}

