/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.world.environment;

import com.crypticmushroom.minecraft.midnight.client.MidnightClient;
import com.crypticmushroom.minecraft.midnight.client.world.environment.MnFogTicker;
import com.crypticmushroom.minecraft.midnight.common.registry.MnDimensions;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class MnEnvironmentSystem {
    static final Marker MARKER = MarkerManager.getMarker((String)"Client/ENVIRONMENT");
    private final MnFogTicker fog = new MnFogTicker();

    static MnEnvironmentSystem get() {
        return MidnightClient.get().getEnvironmentSystem();
    }

    public MnFogTicker getFog() {
        return this.fog;
    }

    public void addEventListeners(IEventBus modBus) {
        MinecraftForge.EVENT_BUS.addListener(this::renderFog);
        MinecraftForge.EVENT_BUS.addListener(this::computeFogColor);
    }

    private void computeFogColor(ViewportEvent.ComputeFogColor event) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        if (!MnDimensions.THE_MIDNIGHT.is((Level)level)) {
            return;
        }
        if (level.m_104819_() > 0) {
            float brightness = (float)level.m_45517_(LightLayer.SKY, BlockPos.m_274446_((Position)minecraft.f_91074_.m_20299_((float)event.getPartialTick()))) / 15.0f;
            event.setRed(Mth.m_14179_((float)(brightness *= 0.6f), (float)event.getRed(), (float)0.5f));
            event.setGreen(Mth.m_14179_((float)brightness, (float)event.getGreen(), (float)0.15f));
            event.setBlue(Mth.m_14179_((float)brightness, (float)event.getBlue(), (float)0.12f));
        }
    }

    private void renderFog(ViewportEvent.RenderFog event) {
        this.fog.tick(event);
    }
}

