/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.world.environment;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.CubicSampler;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class MnDimensionEffects
extends DimensionSpecialEffects {
    private static final ResourceLocation MOON_LOCATION = Midnight.id("textures/environment/moon.png");
    private VertexBuffer starBuffer;
    private VertexBuffer darkBuffer;

    public MnDimensionEffects() {
        super(Float.NaN, true, DimensionSpecialEffects.SkyType.NONE, false, false);
        this.createStars();
        this.createDarkSky();
    }

    public void adjustLightmapColors(ClientLevel level, float partialTicks, float skyDarken, float blockLightRedFlicker, float skyLight, int rawBlockLight, int rawSkyLight, Vector3f colors) {
        Rift rift;
        float skyBrightness = LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)rawSkyLight);
        float modifiedSkyBrightness = skyBrightness * 0.13f;
        float pow = 1.3f;
        float blockLightR = (float)Math.pow(LightTexture.m_234316_((DimensionType)level.m_6042_(), (int)rawBlockLight) * blockLightRedFlicker, pow);
        float blockLightG = blockLightR * ((blockLightR * 0.6f + 0.4f) * 0.6f + 0.4f);
        float blockLightB = blockLightR * (blockLightR * blockLightR * 0.6f + 0.4f);
        colors.set(blockLightR + modifiedSkyBrightness, blockLightG + modifiedSkyBrightness, blockLightB + modifiedSkyBrightness);
        if (level.m_104819_() > 0) {
            colors.lerp((Vector3fc)new Vector3f(0.8f, 0.2f, 0.2f), (1.0f - blockLightR * 0.2f) * skyBrightness);
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && (rift = (Rift)MnDimensionEffects.getNearestEntity(level.m_45976_(Rift.class, player.m_20191_().m_82400_(10.0)), (LivingEntity)player, player.m_20185_(), player.m_20186_(), player.m_20189_())) != null) {
            float dist = Math.min(player.m_20270_((Entity)rift), 10.0f);
            colors.set(colors.x(), Mth.m_14179_((float)(1.0f - Math.max(0.0f, (dist - 2.0f) / 8.0f)), (float)colors.y(), (float)0.0f), Mth.m_14179_((float)(1.0f - Math.max(0.0f, (dist - 2.0f) / 8.0f)), (float)colors.z(), (float)0.0f));
        }
    }

    public static <T extends Entity> T getNearestEntity(List<? extends T> entities, @Nullable LivingEntity target, double x, double y, double z) {
        double d0 = -1.0;
        Entity t = null;
        for (Entity t1 : entities) {
            double d1 = t1.m_20275_(x, y, z);
            if (d0 != -1.0 && !(d1 < d0)) continue;
            d0 = d1;
            t = t1;
        }
        return (T)t;
    }

    public boolean renderSky(ClientLevel level, int ticks, float partialTick, PoseStack poseStack, Camera camera, Matrix4f projectionMatrix, boolean isFoggy, Runnable setupFog) {
        FogType fogtype;
        setupFog.run();
        if (!isFoggy && (fogtype = camera.m_167685_()) != FogType.POWDER_SNOW && fogtype != FogType.LAVA && !this.doesMobEffectBlockSky(camera)) {
            Rift rift;
            Vec3 skyColour = CubicSampler.m_130038_((Vec3)camera.m_90583_().m_82492_(2.0, 2.0, 2.0).m_82490_(0.25), (x, y, z) -> Vec3.m_82501_((int)((Biome)level.m_7062_().m_204210_(x, y, z).m_203334_()).m_47463_()));
            float r = (float)skyColour.f_82479_;
            float g = (float)skyColour.f_82480_;
            float b = (float)skyColour.f_82481_;
            Minecraft mc = Minecraft.m_91087_();
            LocalPlayer player = mc.f_91074_;
            if (player != null && (rift = (Rift)MnDimensionEffects.getNearestEntity(level.m_45976_(Rift.class, player.m_20191_().m_82400_(10.0)), (LivingEntity)player, player.m_20185_(), player.m_20186_(), player.m_20189_())) != null) {
                float dist = Math.min(player.m_20270_((Entity)rift), 10.0f);
                g = Mth.m_14179_((float)(1.0f - Math.max(0.0f, (dist - 2.0f) / 8.0f)), (float)g, (float)0.0f);
                b = Mth.m_14179_((float)(1.0f - Math.max(0.0f, (dist - 2.0f) / 8.0f)), (float)b, (float)0.0f);
            }
            FogRenderer.m_109036_();
            BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            ShaderInstance shaderInstance = RenderSystem.getShader();
            this.darkBuffer.m_85921_();
            this.darkBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, shaderInstance);
            VertexBuffer.m_85931_();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            poseStack.m_85836_();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
            RenderSystem.setShader(GameRenderer::m_172817_);
            float celestialBodiesTop = 61.0f;
            float celestialBodiesEnd = 48.0f;
            double playerY = mc.f_91074_.m_146892_().f_82480_;
            if (playerY > (double)celestialBodiesEnd) {
                float celestialAlpha = (float)Mth.m_14112_((double)playerY, (double)celestialBodiesEnd, (double)celestialBodiesTop);
                float size = 40.0f;
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)MOON_LOCATION);
                bufferbuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
                bufferbuilder.m_252986_(matrix4f, -size, -100.0f, size).m_7421_(0.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f, size, -100.0f, size).m_7421_(1.0f, 0.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f, size, -100.0f, -size).m_7421_(1.0f, 1.0f).m_5752_();
                bufferbuilder.m_252986_(matrix4f, -size, -100.0f, -size).m_7421_(0.0f, 1.0f).m_5752_();
                BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferbuilder.m_231175_());
                float starBrightness = 0.7f;
                if (celestialAlpha > 0.0f) {
                    RenderSystem.setShaderColor((float)starBrightness, (float)starBrightness, (float)starBrightness, (float)celestialAlpha);
                    FogRenderer.m_109017_();
                    this.starBuffer.m_85921_();
                    this.starBuffer.m_253207_(poseStack.m_85850_().m_252922_(), projectionMatrix, GameRenderer.m_172808_());
                    VertexBuffer.m_85931_();
                    setupFog.run();
                }
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            poseStack.m_85849_();
            RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.depthMask((boolean)true);
        }
        return true;
    }

    public Vec3 m_5927_(Vec3 color, float partialTicks) {
        return color;
    }

    public boolean m_5781_(int x, int z) {
        return false;
    }

    private void createStars() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        RenderSystem.setShader(GameRenderer::m_172808_);
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = this.drawStars(bufferbuilder);
        this.starBuffer.m_85921_();
        this.starBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    private BufferBuilder.RenderedBuffer drawStars(BufferBuilder builder) {
        RandomSource randomsource = RandomSource.m_216335_((long)10842L);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85814_);
        for (int i = 0; i < 1500; ++i) {
            double d0 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d1 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d2 = randomsource.m_188501_() * 2.0f - 1.0f;
            double d3 = 0.15f + randomsource.m_188501_() * 0.1f;
            double d4 = d0 * d0 + d1 * d1 + d2 * d2;
            if (!(d4 < 1.0) || !(d4 > 0.01)) continue;
            d4 = 1.0 / Math.sqrt(d4);
            double d5 = (d0 *= d4) * 100.0;
            double d6 = (d1 *= d4) * 100.0;
            double d7 = (d2 *= d4) * 100.0;
            double d8 = Math.atan2(d0, d2);
            double d9 = Math.sin(d8);
            double d10 = Math.cos(d8);
            double d11 = Math.atan2(Math.sqrt(d0 * d0 + d2 * d2), d1);
            double d12 = Math.sin(d11);
            double d13 = Math.cos(d11);
            double d14 = randomsource.m_188500_() * Math.PI * 2.0;
            double d15 = Math.sin(d14);
            double d16 = Math.cos(d14);
            for (int j = 0; j < 4; ++j) {
                double d18 = (double)((j & 2) - 1) * d3;
                double d19 = (double)((j + 1 & 2) - 1) * d3;
                double d21 = d18 * d16 - d19 * d15;
                double d22 = d19 * d16 + d18 * d15;
                double d23 = d21 * d12 + 0.0 * d13;
                double d24 = 0.0 * d12 - d21 * d13;
                double d25 = d24 * d9 - d22 * d10;
                double d26 = d22 * d9 + d24 * d10;
                builder.m_5483_(d5 + d25, d6 + d23, d7 + d26).m_5752_();
            }
        }
        return builder.m_231175_();
    }

    private void createDarkSky() {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder bufferbuilder = tesselator.m_85915_();
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        BufferBuilder.RenderedBuffer bufferbuilder$renderedbuffer = MnDimensionEffects.buildSkyDisc(bufferbuilder, 16.0f);
        this.darkBuffer.m_85921_();
        this.darkBuffer.m_231221_(bufferbuilder$renderedbuffer);
        VertexBuffer.m_85931_();
    }

    private static BufferBuilder.RenderedBuffer buildSkyDisc(BufferBuilder builder, float y) {
        return LevelRenderer.m_234267_((BufferBuilder)builder, (float)y);
    }

    private boolean doesMobEffectBlockSky(Camera camera) {
        LivingEntity livingentity;
        Entity entity = camera.m_90592_();
        return entity instanceof LivingEntity && ((livingentity = (LivingEntity)entity).m_21023_(MobEffects.f_19610_) || livingentity.m_21023_(MobEffects.f_216964_));
    }
}

