/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.util;

import com.crypticmushroom.minecraft.midnight.client.model.entity.AnimatedEntityGeoModel;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.RegistryObject;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;

public final class RenderingUtil {
    public static <E extends LivingEntity> EntityRendererProvider<E> createEntityRenderer(RegistryObject<EntityType<E>> entity) {
        return context -> RenderingUtil.createEntityRenderer(entity.getId().m_135815_(), context);
    }

    public static <E extends LivingEntity> AnimatedEntityGeoModel<E> createEntityModel(String name) {
        return new AnimatedEntityGeoModel<E>(name){};
    }

    private static <E extends LivingEntity> GeoEntityRenderer<E> createEntityRenderer(String name, EntityRendererProvider.Context context) {
        return RenderingUtil.createEntityRenderer(name, context, (EntityRendererProvider.Context m, AnimatedEntityGeoModel<E> c) -> new GeoEntityRenderer<E>((EntityRendererProvider.Context)m, (GeoModel)c){});
    }

    private static <E extends LivingEntity> GeoEntityRenderer<E> createEntityRenderer(String name, EntityRendererProvider.Context context, BiFunction<EntityRendererProvider.Context, AnimatedEntityGeoModel<E>, GeoEntityRenderer<E>> renderer) {
        return RenderingUtil.createEntityRenderer(context, () -> RenderingUtil.createEntityModel(name), renderer);
    }

    private static <E extends LivingEntity> GeoEntityRenderer<E> createEntityRenderer(EntityRendererProvider.Context context, Supplier<AnimatedEntityGeoModel<E>> model, BiFunction<EntityRendererProvider.Context, AnimatedEntityGeoModel<E>, GeoEntityRenderer<E>> renderer) {
        return renderer.apply(context, model.get());
    }
}

