/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.renderer.entity;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.client.renderer.shader.MnShaders;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.RiftBridge;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RiftRenderer<E extends Rift>
extends EntityRenderer<E> {
    private static final double QUAD_WIDTH = 1.8;
    private static final double QUAD_HEIGHT = 2.6;
    public static final ResourceLocation RIFT_NOISE = Midnight.id("textures/effect/rift_noise.png");
    public static final ResourceLocation RIFT_TEXTURE = Midnight.id("textures/entity/rift.png");

    public RiftRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(E entity, float entityYaw, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        try {
            RiftBridge bridge = ((Rift)entity).getBridge();
            if (bridge == null) {
                return;
            }
            float openProgress = bridge.getOpenAnimation(partialTick);
            float unstableTime = bridge.getUnstableAnimation(partialTick);
            if (openProgress > 0.0f) {
                VertexConsumer consumer = buffer.m_6299_(MnShaders.RIFT.getRenderType());
                poseStack.m_85836_();
                poseStack.m_85837_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0);
                poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f - entityYaw));
                float time = (float)((Rift)entity).f_19797_ + partialTick;
                float openAnimation = this.computeOpenAnimation(openProgress);
                float unstableAnimation = this.computeUnstableAnimation(unstableTime);
                float width = 2.0f;
                float height = 4.0f;
                float idleSpeed = 0.08f;
                float idleIntensity = 0.1f * openAnimation * (unstableAnimation * 5.0f + 1.0f);
                float idleAnimation = (Mth.m_14031_((float)(time * idleSpeed)) + 1.0f) * 0.4f * idleIntensity;
                poseStack.m_85841_(openAnimation, openAnimation, 1.0f);
                poseStack.m_85841_(1.0f + idleAnimation, 1.0f + idleAnimation * 0.5f, 1.0f);
                Matrix4f lastPose = poseStack.m_85850_().m_252922_();
                Matrix3f normal = poseStack.m_85850_().m_252943_();
                this.renderTexture(consumer, lastPose, normal, width, height, packedLight);
                poseStack.m_85849_();
            }
        }
        catch (Throwable t) {
            Midnight.LOGGER.fatal((Object)t);
            t.printStackTrace();
            throw new RuntimeException(t);
        }
    }

    private void renderTexture(VertexConsumer consumer, Matrix4f lastPose, Matrix3f normal, float width, float height, int packedLight) {
        consumer.m_252986_(lastPose, -width, height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(lastPose, width, height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(lastPose, width, -height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 0.0f, 0.0f).m_5752_();
        consumer.m_252986_(lastPose, -width, -height, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(normal, 0.0f, 0.0f, 0.0f).m_5752_();
    }

    private float computeOpenAnimation(float openProgress) {
        float openAnimation = openProgress / 20.0f;
        openAnimation = (float)(1.0 - Math.pow(1.0 - (double)openAnimation, 3.0));
        openAnimation = Mth.m_14036_((float)openAnimation, (float)0.0f, (float)1.0f);
        return openAnimation;
    }

    private float computeUnstableAnimation(float unstableTime) {
        float unstableAnimation = unstableTime / 110.0f;
        unstableAnimation = (float)(1.0 - Math.pow(1.0 - (double)unstableAnimation, 2.0));
        unstableAnimation = Mth.m_14036_((float)unstableAnimation, (float)0.0f, (float)1.0f);
        return unstableAnimation;
    }

    @Nullable
    public ResourceLocation getTextureLocation(E entity) {
        return null;
    }
}

