/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.renderer.blockentity;

import java.util.Calendar;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraftforge.registries.ForgeRegistries;

public class MnChestRenderer<T extends BlockEntity>
extends ChestRenderer<T> {
    private static final Map<ResourceLocation, Map<ChestType, Material>> CACHE = new HashMap<ResourceLocation, Map<ChestType, Material>>();
    private final boolean halloween;

    public MnChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        Calendar calendar = Calendar.getInstance();
        this.halloween = calendar.get(2) == 9 && calendar.get(5) >= 29;
    }

    protected final Material getMaterial(T blockEntity, ChestType chestType) {
        Map map = CACHE.computeIfAbsent(ForgeRegistries.BLOCKS.getKey((Object)blockEntity.m_58900_().m_60734_()), k -> Collections.unmodifiableMap(new EnumMap<ChestType, Material>(ChestType.class){
            {
                super(keyType);
                for (ChestType c : ChestType.values()) {
                    this.put(c, MnChestRenderer.createMaterial(k, c));
                }
            }
        }));
        return (Material)map.get(chestType);
    }

    private static Material createMaterial(ResourceLocation id, ChestType chestType) {
        String string = id.m_135827_();
        return new Material(Sheets.f_110740_, new ResourceLocation(string, switch (chestType) {
            default -> throw new IncompatibleClassChangeError();
            case ChestType.SINGLE -> "entity/chest/" + id.m_135815_();
            case ChestType.LEFT -> "entity/chest/" + id.m_135815_() + "_left";
            case ChestType.RIGHT -> "entity/chest/" + id.m_135815_() + "_right";
        }));
    }
}

