/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.particle;

import com.crypticmushroom.minecraft.midnight.client.particle.MnTextureSheetParticle;
import com.crypticmushroom.minecraft.midnight.common.util.ColorUtil;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RisingSporeParticle
extends MnTextureSheetParticle {
    private final double verticalAcceleration;

    public RisingSporeParticle(ClientLevel level, double x, double y, double z, float xvMul, float yvMul, float zvMul, double xv, double yv, double zv, float scaling, SpriteSet sprites, double randomLighting, double r, double g, double b, int averageAge, double vertAcceleration, boolean collideable) {
        super(level, x, y, z, 0.0, 0.0, 0.0, sprites);
        this.verticalAcceleration = vertAcceleration;
        this.f_107215_ *= (double)xvMul;
        this.f_107216_ *= (double)yvMul;
        this.f_107217_ *= (double)zvMul;
        this.f_107215_ += xv;
        this.f_107216_ += yv;
        this.f_107217_ += zv;
        float shade = (level.f_46441_.m_188501_() * 2.0f - 1.0f) * (float)randomLighting;
        this.f_107227_ = Mth.m_14036_((float)((float)r + shade), (float)0.0f, (float)1.0f);
        this.f_107228_ = Mth.m_14036_((float)((float)g + shade), (float)0.0f, (float)1.0f);
        this.f_107229_ = Mth.m_14036_((float)((float)b + shade), (float)0.0f, (float)1.0f);
        this.f_107663_ = (float)((double)this.f_107663_ * (0.75 * (double)scaling));
        this.f_107225_ = (int)((double)averageAge / (level.f_46441_.m_188500_() * 0.8 + 0.2));
        this.f_107225_ = (int)((float)this.f_107225_ * scaling);
        this.f_107225_ = Math.max(this.f_107225_, 1);
        this.f_107219_ = collideable;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    public float m_5902_(float partialTicks) {
        return this.f_107663_ * Mth.m_14036_((float)(((float)this.f_107224_ + partialTicks) / (float)this.f_107225_ * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void m_6257_(double xv, double yv, double zv) {
        double fxv = xv;
        double fyv = yv;
        double fzv = zv;
        if (this.f_107219_ && (xv != 0.0 || yv != 0.0 || zv != 0.0)) {
            Vec3 collisionResult = Entity.m_198894_(null, (Vec3)new Vec3(xv, yv, zv), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            xv = collisionResult.f_82479_;
            yv = collisionResult.f_82480_;
            zv = collisionResult.f_82481_;
        }
        if (xv != 0.0 || yv != 0.0 || zv != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(xv, yv, zv));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = fyv != yv && fyv < 0.0;
        if (fxv != xv) {
            this.f_107215_ = 0.0;
        }
        if (fyv != yv) {
            this.f_107216_ = 0.0;
        }
        if (fzv != zv) {
            this.f_107217_ = 0.0;
        }
    }

    @Override
    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        } else {
            this.updateSprite();
            this.f_107216_ += this.verticalAcceleration;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            if (this.f_107213_ == this.f_107210_) {
                this.f_107215_ *= 1.1;
                this.f_107217_ *= 1.1;
            }
            this.f_107215_ *= 0.96;
            this.f_107216_ *= 0.96;
            this.f_107217_ *= 0.96;
            if (this.f_107218_) {
                this.f_107215_ *= 0.7;
                this.f_107217_ *= 0.7;
            }
        }
    }

    public int m_6355_(float partialTicks) {
        int skylight = 10;
        int blocklight = 5;
        return skylight << 20 | blocklight << 4;
    }

    public static ParticleProvider<SimpleParticleType> shroomProvider(SpriteSet sprites) {
        return (type, level, x, y, z, r, g, b) -> new RisingSporeParticle(level, x, y, z, 0.5f, 0.5f, 0.5f, 0.0, 0.0, 0.0, 0.4f, sprites, 0.1, r, g, b, 90, -0.01, true);
    }

    public static ParticleProvider<SimpleParticleType> tendrilweedProvider(SpriteSet sprites) {
        int color = 11230823;
        double r = ColorUtil.redd(color);
        double g = ColorUtil.greend(color);
        double b = ColorUtil.blued(color);
        return (type, level, x, y, z, xSpeed, ySpeed, zSpeed) -> new RisingSporeParticle(level, x, y, z, 0.1f, 0.1f, 0.1f, xSpeed, ySpeed, zSpeed, 0.9f, sprites, 0.1, r, g, b, 30, -0.002, true);
    }
}

