/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.particle;

import com.crypticmushroom.minecraft.midnight.client.particle.MnTextureSheetParticle;
import com.crypticmushroom.minecraft.midnight.client.particle.RiftParticleSystem;
import com.crypticmushroom.minecraft.midnight.common.entity.rift.Rift;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.util.Mth;
import org.joml.Quaternionf;

public class RiftParticle
extends MnTextureSheetParticle {
    private static final int TRANSITION_TIME = 20;
    private static final float MIN_RETURN_DISTANCE = 0.2f;
    private static final int MIN_RETURN_CHANCE = 400;
    private static final int RETURN_DECAY_TIME = 98;
    private final RiftParticleSystem particleSystem;
    private final Ring ring;
    private final double startX;
    private final double startY;
    private final double startZ;
    private final float radius;
    private final float angleOffset;
    private final float verticalOffset;
    private final float rotateSpeed;
    private final PoseStack matrix = new PoseStack();
    private int transitionTime;
    private boolean returning;

    protected RiftParticle(RiftParticleSystem particleSystem, Ring ring, ClientLevel level, double x, double y, double z, float radius, float angleOffset, float verticalOffset, float rotateSpeed, SpriteSet sprites) {
        super(level, x, y, z, sprites);
        float shade;
        this.m_107250_(0.2f, 0.2f);
        this.particleSystem = particleSystem;
        this.radius = radius;
        this.angleOffset = angleOffset;
        this.verticalOffset = verticalOffset;
        this.rotateSpeed = rotateSpeed;
        this.ring = ring;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.f_107227_ = shade = this.f_107223_.m_188501_() * 0.1f + 0.2f;
        this.f_107228_ = shade;
        this.f_107229_ = shade;
        this.f_107663_ *= (this.f_107223_.m_188501_() * 0.6f + 2.0f) * 0.3f;
        this.f_107219_ = false;
    }

    @Override
    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        Rift rift = this.particleSystem.getEntity();
        if (this.shouldExpire() || rift.isBridgeInvalid()) {
            this.m_107274_();
            this.particleSystem.returnParticle();
            return;
        }
        int gradient = 4;
        int returnChance = Mth.m_14045_((int)(gradient * (98 - rift.getBridge().unstable.getTimer())), (int)1, (int)400);
        if (this.f_107223_.m_188503_(returnChance) == 0) {
            this.returning = true;
        }
        this.updateTransitionTimer();
        float transitionAnimation = (float)this.transitionTime / 20.0f;
        transitionAnimation = (float)(1.0 - Math.pow(1.0f - transitionAnimation, 3.0));
        Point target = this.computeTarget();
        this.f_107212_ = this.startX + ((double)target.x - this.startX) * (double)transitionAnimation;
        this.f_107213_ = this.startY + ((double)target.y - this.startY) * (double)transitionAnimation;
        this.f_107214_ = this.startZ + ((double)target.z - this.startZ) * (double)transitionAnimation;
        ++this.f_107224_;
    }

    private void updateTransitionTimer() {
        if (this.returning && this.transitionTime > 0) {
            --this.transitionTime;
        } else if (this.transitionTime < 20) {
            ++this.transitionTime;
        }
    }

    private boolean shouldExpire() {
        if (!this.particleSystem.getEntity().m_6084_()) {
            return true;
        }
        if (!this.returning) {
            return false;
        }
        double deltaX = this.f_107212_ - this.startX;
        double deltaY = this.f_107213_ - this.startY;
        double deltaZ = this.f_107214_ - this.startZ;
        double distanceSq = deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ;
        return distanceSq < 0.04000000283122063;
    }

    private Point computeTarget() {
        this.matrix.m_85836_();
        this.matrix.m_252781_(new Quaternionf(this.ring.getTiltX(), 1.0f, 0.0f, 0.0f));
        this.matrix.m_252781_(new Quaternionf(this.ring.getTiltZ(), 0.0f, 0.0f, 1.0f));
        this.matrix.m_252781_(new Quaternionf((float)this.f_107224_ * this.rotateSpeed + this.angleOffset, 0.0f, 1.0f, 0.0f));
        float x = this.radius;
        float y = this.verticalOffset;
        float z = 0.0f;
        this.matrix.m_252781_(new Quaternionf(x, y, z, 1.0f));
        this.matrix.m_85849_();
        Rift rift = this.particleSystem.getEntity();
        float targetX = (float)rift.m_20185_() + x;
        float targetY = (float)rift.m_20186_() + rift.m_20206_() / 2.0f + y;
        float targetZ = (float)rift.m_20189_() + z;
        return new Point(targetX, targetY, targetZ);
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107430_;
    }

    public static class Ring {
        private float tiltX;
        private float tiltZ;
        private final float tiltSpeedX;
        private final float tiltSpeedZ;

        public Ring(float tiltX, float tiltZ, float tiltSpeedX, float tiltSpeedZ) {
            this.tiltX = tiltX;
            this.tiltZ = tiltZ;
            this.tiltSpeedX = tiltSpeedX;
            this.tiltSpeedZ = tiltSpeedZ;
        }

        public void update() {
            this.tiltX += this.tiltSpeedX;
            this.tiltZ += this.tiltSpeedZ;
        }

        public float getTiltX() {
            return this.tiltX;
        }

        public float getTiltZ() {
            return this.tiltZ;
        }
    }

    private record Point(float x, float y, float z) {
    }
}

