/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight.client.audio;

import com.crypticmushroom.minecraft.midnight.common.registry.MnBiomes;
import com.crypticmushroom.minecraft.midnight.common.registry.MnSoundEvents;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.util.NonNullLazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public final class MnMusic {
    private static final List<MnMusic> ALL = new ArrayList<MnMusic>();
    private static final List<MnMusic> TRUE = new ArrayList<MnMusic>();
    private static final List<MnMusic> AMBIENT = new ArrayList<MnMusic>();
    public static final MnMusic CRYSTALS = new MnMusic((Supplier<? extends SoundEvent>)MnSoundEvents.MUSIC_CRYSTALS, true, 1200, 1500, (ResourceKey<Biome>[])new ResourceKey[]{MnBiomes.CRYSTAL_SPIRES});
    public static final MnMusic DARK_WILLOW = new MnMusic((Supplier<? extends SoundEvent>)MnSoundEvents.MUSIC_DARKWILLOW, true, 1200, 1500, (ResourceKey<Biome>[])new ResourceKey[]{MnBiomes.VIGILANT_FOREST});
    public static final MnMusic STEGANO = new MnMusic((Supplier<? extends SoundEvent>)MnSoundEvents.MUSIC_AMBIENT_STEGANO, false, 1200, 1500, (ResourceKey<Biome>[])new ResourceKey[0]);
    public static final MnMusic ULTRAVIOLET = new MnMusic((Supplier<? extends SoundEvent>)MnSoundEvents.MUSIC_AMBIENT_ULTRAVIOLET, false, 1200, 1500, (ResourceKey<Biome>[])new ResourceKey[0]);
    public static final MnMusic CUBENSIS = new MnMusic((Supplier<? extends SoundEvent>)MnSoundEvents.MUSIC_AMBIENT_CUBENSIS, false, 1200, 1500, (ResourceKey<Biome>[])new ResourceKey[0]);
    static final int DEFAULT_MIN_DELAY = 1200;
    static final int DEFAULT_MAX_DELAY = 1500;
    private final Supplier<? extends SoundEvent> soundEvent;
    private final NonNullLazy<ResourceLocation> id;
    final Predicate<Minecraft> shouldPlay;
    public final boolean isTrue;
    public final int minDelay;
    public final int maxDelay;

    @SafeVarargs
    public MnMusic(Supplier<? extends SoundEvent> soundEvent, boolean isTrue, int minDelay, int maxDelay, ResourceKey<Biome> ... biomes) {
        this(soundEvent, isTrue, minDelay, maxDelay, biomes.length > 0 ? minecraft -> {
            for (ResourceKey biome : biomes) {
                if (!minecraft.f_91073_.m_204166_(minecraft.f_91074_.m_20183_()).m_203565_(biome)) continue;
                return true;
            }
            return false;
        } : minecraft -> true);
    }

    public MnMusic(Supplier<? extends SoundEvent> soundEvent, boolean isTrue, int minDelay, int maxDelay, Predicate<Minecraft> shouldPlay) {
        this.soundEvent = soundEvent;
        this.id = NonNullLazy.of(() -> Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)this.soundEvent.get()), "Please register your sound event to use it with the Midnight music system"));
        this.shouldPlay = shouldPlay;
        this.isTrue = isTrue;
        this.minDelay = minDelay;
        this.maxDelay = maxDelay;
        ALL.add(this);
        (this.isTrue ? TRUE : AMBIENT).add(this);
    }

    public SoundEvent getSoundEvent() {
        return this.soundEvent.get();
    }

    @Nullable
    public static MnMusic get(ResourceLocation location) {
        for (MnMusic track : ALL) {
            if (!((ResourceLocation)track.id.get()).equals((Object)location)) continue;
            return track;
        }
        return null;
    }

    public static List<MnMusic> getTrueMusic() {
        return new ArrayList<MnMusic>(TRUE);
    }

    public static List<MnMusic> getAmbientMusic() {
        return new ArrayList<MnMusic>(AMBIENT);
    }

    public String toString() {
        return ((ResourceLocation)this.id.get()).toString();
    }
}

