/*
 * Decompiled with CFR 0.152.
 */
package com.crypticmushroom.minecraft.midnight;

import com.crypticmushroom.minecraft.midnight.Midnight;
import com.crypticmushroom.minecraft.midnight.MidnightInfo;
import com.crypticmushroom.minecraft.midnight.common.config.MidnightConfig;
import com.crypticmushroom.minecraft.midnight.common.registry.MnRegistry;
import com.crypticmushroom.minecraft.registry.CrypticRegistry;
import com.google.common.reflect.Reflection;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

@Mod(value="midnight")
public class MidnightMod {
    public static final Marker INIT_MARKER;

    public MidnightMod() {
        Midnight.LOGGER.info("Welcome back to The Midnight. Shall we resume the spread of the malaise?");
        this.printInfo();
        Midnight.LOGGER.debug(INIT_MARKER, "Registering configs");
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)MidnightConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)MidnightConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)MidnightConfig.SERVER_SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        Midnight.LOGGER.debug("Preparing registry data for Cryptic Registry");
        CrypticRegistry.prepare(MnRegistry.class, (IEventBus)modBus);
        Midnight.LOGGER.debug(INIT_MARKER, "Registering event listeners");
        Midnight.get().addEventListeners(modBus);
        modBus.addListener(this::setup);
        modBus.addListener(this::loadComplete);
        Midnight.get().preInit();
        Midnight.LOGGER.debug(INIT_MARKER, "Midnight pre-initialized");
    }

    private void setup(FMLCommonSetupEvent event) {
        Midnight.get().init();
        Midnight.LOGGER.debug(INIT_MARKER, "Midnight initialized");
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        Midnight.get().postInit();
        Midnight.LOGGER.debug(INIT_MARKER, "Midnight post-initialized");
    }

    private void printInfo() {
        Level logLevel = MidnightInfo.IDE ? Level.INFO : Level.DEBUG;
        StringBuilder debugInfo = new StringBuilder();
        debugInfo.append('\n');
        debugInfo.append("%s Debug Build Information\n".formatted("The Midnight"));
        debugInfo.append(" - Version:     %s - %s\n".formatted("0.6.5", "Call of the Malaise"));
        debugInfo.append(" - Dist:        %s\n".formatted(DatagenModLoader.isRunningDataGen() ? "DATAGEN" : FMLEnvironment.dist.toString()));
        debugInfo.append(" - Environment: %s".formatted(MidnightInfo.IDE ? "IDE/Gradle" : "Normal"));
        Midnight.LOGGER.log(logLevel, INIT_MARKER, (CharSequence)debugInfo);
    }

    static {
        Reflection.initialize((Class[])new Class[]{Midnight.class});
        INIT_MARKER = MarkerManager.getMarker((String)"INIT");
    }
}

