/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.screen;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.screen.GuideScreenHistory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class GlobalInMemoryHistory
implements GuideScreenHistory {
    public static final GuideScreenHistory INSTANCE = new GlobalInMemoryHistory();
    private static final int HISTORY_SIZE = 100;
    private static final List<PageAnchor> history = new ArrayList<PageAnchor>();
    private static int historyPosition;

    @Override
    public PageAnchor get(int index) {
        return null;
    }

    @Override
    public void push(PageAnchor anchor) {
        if (historyPosition + 1 < history.size()) {
            history.subList(historyPosition + 1, history.size()).clear();
        }
        if (history.size() >= 100) {
            history.subList(0, history.size() - 100).clear();
        }
        historyPosition = history.size();
        history.add(anchor);
    }

    @Override
    public Optional<PageAnchor> current() {
        if (historyPosition < history.size()) {
            return Optional.of(history.get(historyPosition));
        }
        return Optional.empty();
    }

    @Override
    public Optional<PageAnchor> forward() {
        Optional<PageAnchor> page = this.peekForward();
        if (page.isPresent()) {
            ++historyPosition;
        }
        return page;
    }

    @Override
    public Optional<PageAnchor> back() {
        Optional<PageAnchor> page = this.peekBack();
        if (page.isPresent()) {
            --historyPosition;
        }
        return page;
    }

    @Override
    public Optional<PageAnchor> peekForward() {
        if (historyPosition + 1 < history.size()) {
            return Optional.of(history.get(historyPosition + 1));
        }
        return Optional.empty();
    }

    @Override
    public Optional<PageAnchor> peekBack() {
        if (historyPosition > 0) {
            return Optional.of(history.get(historyPosition - 1));
        }
        return Optional.empty();
    }
}

