/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.block;

import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.ItemWithBannerPattern;
import vazkii.botania.common.lib.BotaniaTags;

public class TinyPotatoBlockItem
extends BlockItem
implements ItemWithBannerPattern {
    private static final Pattern TYPOS = Pattern.compile("(?!^vazkii$)^v[ao]{1,2}[sz]{0,2}[ak]{1,2}(i){1,2}l{0,2}$", 2);
    private static final List<String> ENCHANTMENT_NAMES = List.of("enchanted", "glowy", "shiny", "gay");
    private static final int NOT_MY_NAME = 17;
    private static final String TAG_TICKS = "notMyNameTicks";

    public TinyPotatoBlockItem(Block block, Item.Properties props) {
        super(block, props);
    }

    @Override
    public TagKey<BannerPattern> getBannerPattern() {
        return BotaniaTags.BannerPatterns.PATTERN_ITEM_TINY_POTATO;
    }

    public void m_6883_(ItemStack stack, Level world, Entity e, int t, boolean idunno) {
        if (!world.f_46443_ && e instanceof Player) {
            int ticks;
            Player player = (Player)e;
            if (e.f_19797_ % 30 == 0 && TYPOS.matcher(stack.m_41786_().getString()).matches() && (ticks = ItemNBTHelper.getInt(stack, TAG_TICKS, 0)) < 17) {
                player.m_213846_((Component)Component.m_237115_((String)("botania.tater.you_came_to_the_wrong_neighborhood." + ticks)).m_130940_(ChatFormatting.RED));
                ItemNBTHelper.setInt(stack, TAG_TICKS, ticks + 1);
            }
        }
    }

    public static boolean isEnchantedName(@NotNull Component name, @Nullable StringBuilder nameBuilder) {
        String trimmed = name.getString().trim();
        String nameString = trimmed.toLowerCase(Locale.ROOT);
        for (String prefix : ENCHANTMENT_NAMES) {
            if (!nameString.equals(prefix) && !nameString.startsWith(prefix + " ")) continue;
            if (nameBuilder != null) {
                if (trimmed.length() > prefix.length()) {
                    nameBuilder.append(trimmed, prefix.length() + 1, trimmed.length());
                } else {
                    nameBuilder.append(trimmed);
                }
            }
            return true;
        }
        if (nameBuilder != null) {
            nameBuilder.append(trimmed);
        }
        return false;
    }

    public static String removeFromFront(String name, String match) {
        return name.substring(match.length()).trim();
    }

    public boolean m_5812_(@NotNull ItemStack stack) {
        return super.m_5812_(stack) || TinyPotatoBlockItem.isEnchantedName(stack.m_41786_(), null);
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, Entity entity) {
        Player player;
        return armorType == this.getEquipmentSlot(stack) && entity instanceof Player && ContributorList.hasFlower((player = (Player)entity).m_36316_().getName().toLowerCase(Locale.ROOT));
    }
}

