/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.BasicLensItem;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.ManaBlasterItem;

public class ManaBlasterLensRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<ManaBlasterLensRecipe> SERIALIZER = new NoOpRecipeSerializer<ManaBlasterLensRecipe>(ManaBlasterLensRecipe::new);

    public ManaBlasterLensRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        int foundLens = 0;
        int foundGun = 0;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ManaBlasterItem && ManaBlasterItem.getLens(stack).m_41619_()) {
                ++foundGun;
                continue;
            }
            if (ManaBlasterItem.isValidLens(stack)) {
                ++foundLens;
                continue;
            }
            return false;
        }
        return foundLens == 1 && foundGun == 1;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack lens = ItemStack.f_41583_;
        ItemStack gun = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ManaBlasterItem) {
                gun = stack;
                continue;
            }
            if (!(stack.m_41720_() instanceof BasicLensItem)) continue;
            lens = stack.m_255036_(1);
        }
        if (lens.m_41619_() || gun.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack gunCopy = gun.m_41777_();
        ManaBlasterItem.setLens(gunCopy, lens);
        return gunCopy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

