/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.world.biomemodifier;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.configuration.DebugConfig;
import xratedjunior.betterdefaultbiomes.configuration.MobSpawningConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.CamelConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.DesertBanditConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.DuckConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.FrogConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.FrozenZombieConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.HunterConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.JungleCreeperConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.LostMinerConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.MuddyPigConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.ZebraConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.util.MobConfig;
import xratedjunior.betterdefaultbiomes.entity.BDBEntityTypes;
import xratedjunior.betterdefaultbiomes.util.BDBHelper;
import xratedjunior.betterdefaultbiomes.world.BDBBiomeModifiers;

public record AddSpawnsWithConfig() implements BiomeModifier
{
    public static final Codec<AddSpawnsWithConfig> CODEC = Codec.unit(AddSpawnsWithConfig::new);

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            boolean spawnLogger = (Boolean)DebugConfig.spawn_logger.get();
            boolean allSpawnLogger = (Boolean)DebugConfig.spawn_logger_all.get();
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.LOST_MINER.get(), (Boolean)MobSpawningConfig.spawn_lost_miners.get(), new LostMinerConfig(), allSpawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.HUNTER.get(), (Boolean)MobSpawningConfig.spawn_hunters.get(), new HunterConfig(), spawnLogger);
            AddSpawnsWithConfig.addSpawn(builder, biome, (EntityType)BDBEntityTypes.HEAD_HUNTER.get(), (Boolean)MobSpawningConfig.spawn_hunters.get() != false && (Boolean)HunterConfig.spawn_head_hunter.get() != false, (List)HunterConfig.spawn_biomes.get(), (Integer)HunterConfig.head_hunter_weight.get(), 1, 1, spawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.JUNGLE_CREEPER.get(), (Boolean)MobSpawningConfig.spawn_jungle_creepers.get(), new JungleCreeperConfig(), spawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.DESERT_BANDIT.get(), (Boolean)MobSpawningConfig.spawn_desert_bandits.get(), new DesertBanditConfig(), spawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.FROZEN_ZOMBIE.get(), (Boolean)MobSpawningConfig.spawn_frozen_zombie.get(), new FrozenZombieConfig(), spawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.MUDDY_PIG.get(), (Boolean)MobSpawningConfig.spawn_muddy_pig.get(), new MuddyPigConfig(), spawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.CAMEL.get(), (Boolean)MobSpawningConfig.spawn_camel.get(), new CamelConfig(), spawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.DUCK.get(), (Boolean)MobSpawningConfig.spawn_duck.get(), new DuckConfig(), spawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.ZEBRA.get(), (Boolean)MobSpawningConfig.spawn_zebra.get(), new ZebraConfig(), spawnLogger);
            this.addSpawn(builder, biome, (EntityType)BDBEntityTypes.FROG.get(), (Boolean)MobSpawningConfig.spawn_frog.get(), new FrogConfig(), spawnLogger);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)BDBBiomeModifiers.ADD_SPAWNS_CODEC.get();
    }

    private <MC extends MobConfig> void addSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, Holder<Biome> biome, EntityType<?> entityType, boolean spawnMob, MC mobConfig, boolean spawnLogger) {
        AddSpawnsWithConfig.addSpawn(builder, biome, entityType, spawnMob, mobConfig.getSpawnBiomes(), mobConfig.getWeight(), mobConfig.getMinGroup(), mobConfig.getMaxGroup(), spawnLogger);
    }

    private static void addSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, Holder<Biome> biome, EntityType<?> entityType, boolean spawnMob, List<String> spawn_biomes, int weight, int minGroup, int maxGroup, boolean spawnLogger) {
        if (spawnMob && BDBHelper.matchBiomeOrTag(biome, spawn_biomes) && weight > 0) {
            if (minGroup <= maxGroup) {
                AddSpawnsWithConfig.addSpawn(builder, biome, entityType, weight, minGroup, maxGroup, spawnLogger);
            } else {
                AddSpawnsWithConfig.addSpawn(builder, biome, entityType, weight, maxGroup, minGroup, spawnLogger);
                BetterDefaultBiomes.LOGGER.warn("The minGroup in the Config file is bigger than the maxGroup for the \"{}\".", (Object)entityType.m_147048_());
                BetterDefaultBiomes.LOGGER.warn("Normally this would cause the game to crash, but we switched the values around.");
            }
        }
    }

    private static void addSpawn(ModifiableBiomeInfo.BiomeInfo.Builder builder, Holder<Biome> biome, EntityType<?> entityType, int weight, int minGroup, int maxGroup, boolean spawnLogger) {
        builder.getMobSpawnSettings().m_48376_(entityType.m_20674_(), new MobSpawnSettings.SpawnerData(entityType, weight, minGroup, maxGroup));
        if (spawnLogger) {
            String spawnProperties = "Weight: " + weight + ", Min Group: " + minGroup + ", Max Group: " + maxGroup;
            BetterDefaultBiomes.LOGGER.info("The " + entityType.m_147048_().toUpperCase() + " spawns in the: " + ((ResourceKey)biome.m_203543_().get()).m_135782_().toString() + ". (" + spawnProperties + ")");
        }
    }
}

