/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.util;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.biome.Biome;

public class BDBHelper {
    public static final Component HOLD_SHIFT_TOOLTIP = Component.m_237115_((String)"tooltip.betterdefaultbiomes.hold_shift").m_130940_(ChatFormatting.DARK_GRAY);

    public static void addPotionTooltip(MobEffectInstance mobEffectInstance, List<Component> tooltip) {
        BDBHelper.addPotionTooltip(mobEffectInstance, tooltip, null);
    }

    public static void addPotionTooltip(MobEffectInstance mobEffectInstance, List<Component> tooltip, @Nullable ChatFormatting customColor) {
        BDBHelper.addPotionTooltip(mobEffectInstance, tooltip, 1.0f, customColor);
    }

    public static void addPotionTooltip(MobEffectInstance mobEffectInstance, List<Component> tooltip, float durationMultiplier, @Nullable ChatFormatting customColor) {
        ArrayList<Pair> attributeList = new ArrayList<Pair>();
        MutableComponent effectName = Component.m_237115_((String)mobEffectInstance.m_19576_());
        MobEffect mobEffect = mobEffectInstance.m_19544_();
        Map attributeModifiers = mobEffect.m_19485_();
        if (!attributeModifiers.isEmpty()) {
            for (Map.Entry modifier : attributeModifiers.entrySet()) {
                AttributeModifier attributemodifier = (AttributeModifier)modifier.getValue();
                AttributeModifier amplifiedAttributeModifier = new AttributeModifier(attributemodifier.m_22214_(), mobEffect.m_7048_(mobEffectInstance.m_19564_(), attributemodifier), attributemodifier.m_22217_());
                attributeList.add(new Pair((Object)((Attribute)modifier.getKey()), (Object)amplifiedAttributeModifier));
            }
        }
        if (mobEffectInstance.m_19564_() > 0) {
            effectName = Component.m_237110_((String)"potion.withAmplifier", (Object[])new Object[]{effectName, Component.m_237115_((String)("potion.potency." + mobEffectInstance.m_19564_()))});
        }
        if (mobEffectInstance.m_19557_() > 20) {
            effectName = Component.m_237110_((String)"potion.withDuration", (Object[])new Object[]{effectName, MobEffectUtil.m_267641_((MobEffectInstance)mobEffectInstance, (float)durationMultiplier)});
        }
        if (customColor == null) {
            tooltip.add((Component)effectName.m_130940_(mobEffect.m_19483_().m_19497_()));
        } else {
            tooltip.add((Component)effectName.m_130940_(customColor));
        }
        if (!attributeList.isEmpty()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"potion.whenDrank").m_130940_(ChatFormatting.DARK_PURPLE));
            for (Pair attributeAndModifier : attributeList) {
                AttributeModifier amplifiedAttributeModifier = (AttributeModifier)attributeAndModifier.getSecond();
                double modificationAmount = amplifiedAttributeModifier.m_22218_();
                double multipliedAmount = amplifiedAttributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && amplifiedAttributeModifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? amplifiedAttributeModifier.m_22218_() : amplifiedAttributeModifier.m_22218_() * 100.0;
                if (modificationAmount > 0.0) {
                    tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.plus." + amplifiedAttributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(multipliedAmount), Component.m_237115_((String)((Attribute)attributeAndModifier.getFirst()).m_22087_())}).m_130940_(ChatFormatting.BLUE));
                    continue;
                }
                if (!(modificationAmount < 0.0)) continue;
                tooltip.add((Component)Component.m_237110_((String)("attribute.modifier.take." + amplifiedAttributeModifier.m_22217_().m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(multipliedAmount *= -1.0), Component.m_237115_((String)((Attribute)attributeAndModifier.getFirst()).m_22087_())}).m_130940_(ChatFormatting.RED));
            }
        }
    }

    public static boolean matchBiomeOrTag(Holder<Biome> biome, List<String> spawnInputs) {
        if (!spawnInputs.isEmpty()) {
            for (String spawnInput : spawnInputs) {
                if (spawnInput.contains("&")) {
                    String[] tagArray = spawnInput.split("&");
                    for (int tag = 0; tag < tagArray.length && BDBHelper.matchTag(biome, tagArray[tag].trim()); ++tag) {
                        if (tag != tagArray.length - 1) continue;
                        return true;
                    }
                    continue;
                }
                if (!BDBHelper.matchBiomeOrTag(biome, spawnInput)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchBiomeOrTag(Holder<Biome> biome, String spawnInput) {
        if (BDBHelper.matchBiome(biome, spawnInput)) {
            return true;
        }
        return BDBHelper.matchTag(biome, spawnInput);
    }

    private static boolean matchBiome(Holder<Biome> biome, String biomeInput) {
        ResourceLocation location = new ResourceLocation(biomeInput);
        ResourceKey biomeKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)location);
        return biome.m_203565_(biomeKey);
    }

    private static boolean matchTag(Holder<Biome> biome, String tagInput) {
        ResourceLocation tagLocation = new ResourceLocation(tagInput);
        TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)tagLocation);
        return biome.containsTag(tagKey);
    }
}

