/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import xratedjunior.betterdefaultbiomes.entity.BDBEntityTypes;
import xratedjunior.betterdefaultbiomes.entity.ai.attribute.BDBCreatureAttribute;
import xratedjunior.betterdefaultbiomes.entity.hostile.AbstractHostileHumanoid;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditArbalistEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditArcherEntity;
import xratedjunior.betterdefaultbiomes.entity.hostile.desertbandit.DesertBanditMasterEntity;
import xratedjunior.betterdefaultbiomes.entity.projectile.BanditArrowEntity;

public class DesertBanditEntity
extends AbstractHostileHumanoid {
    private static final Item BANDIT_SWORD = Items.f_42383_;
    public static float armorDropChance = 0.08f;
    public static int flameChance = 100;
    public static int infinityChance = 300;
    public static int multiShotChance = 200;
    public static int fireAspectChance = 100;

    public DesertBanditEntity(EntityType<? extends DesertBanditEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 6.0f, 1.0, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[]{DesertBanditEntity.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Rabbit.class, true));
    }

    @Override
    protected AbstractArrow getArrow(ItemStack arrowStack, float distanceFactor) {
        return BanditArrowEntity.shootBanditArrow((LivingEntity)this, arrowStack, distanceFactor);
    }

    public static AttributeSupplier.Builder createDesertBanditAttributes() {
        return DesertBanditEntity.createHumanoidAttributes();
    }

    @Override
    public MobType m_6336_() {
        return BDBCreatureAttribute.DESERT_BANDIT;
    }

    public static boolean checkBanditSpawnRules(EntityType<? extends DesertBanditEntity> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return AbstractHostileHumanoid.checkHostileSpawnRules(type, worldIn, reason, pos, randomIn) && pos.m_123342_() > worldIn.m_5736_() && worldIn.m_45517_(LightLayer.SKY, pos) > 4 && worldIn.m_45517_(LightLayer.BLOCK, pos) <= 0;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (reason == MobSpawnType.NATURAL) {
            this.setSpawnGroup();
        }
        return spawnDataIn;
    }

    protected void setSpawnGroup() {
        int archerChance = 15;
        int arbalistChance = 5;
        int masterChance = 2;
        int archerChanceInput = archerChance;
        int arbalistChanceInput = archerChanceInput + arbalistChance;
        int masterChanceInput = arbalistChanceInput + masterChance;
        float chanceGenerator = Math.round(this.f_19796_.m_188501_() * 100.0f);
        if (chanceGenerator < (float)archerChanceInput) {
            DesertBanditArcherEntity newDesertBanditArcher = (DesertBanditArcherEntity)((EntityType)BDBEntityTypes.DESERT_BANDIT_ARCHER.get()).m_20615_(this.m_20193_());
            newDesertBanditArcher.m_20035_(this.m_20183_(), this.m_146908_(), this.m_146909_());
            this.m_20193_().m_7967_((Entity)newDesertBanditArcher);
            DesertBanditArcherEntity.desertBanditArcherDefaultEquipment(newDesertBanditArcher);
        } else if (chanceGenerator < (float)arbalistChanceInput) {
            DesertBanditArbalistEntity newDesertBanditArbalist = (DesertBanditArbalistEntity)((EntityType)BDBEntityTypes.DESERT_BANDIT_ARBALIST.get()).m_20615_(this.m_20193_());
            newDesertBanditArbalist.m_20035_(this.m_20183_(), this.m_146908_(), this.m_146909_());
            this.m_20193_().m_7967_((Entity)newDesertBanditArbalist);
            DesertBanditArbalistEntity.desertBanditArbalistDefaultEquipment(newDesertBanditArbalist);
        } else if (chanceGenerator < (float)masterChanceInput) {
            DesertBanditMasterEntity newDesertBanditMaster = (DesertBanditMasterEntity)((EntityType)BDBEntityTypes.DESERT_BANDIT_MASTER.get()).m_20615_(this.m_20193_());
            newDesertBanditMaster.m_20035_(this.m_20183_(), this.m_146908_(), this.m_146909_());
            this.m_20193_().m_7967_((Entity)newDesertBanditMaster);
            DesertBanditMasterEntity.desertBanditMasterDefaultEquipment(newDesertBanditMaster);
        }
    }

    @Override
    protected void setDefaultEquipmentAndEnchants(DifficultyInstance difficulty) {
        ItemStack desertBanditSword = new ItemStack((ItemLike)BANDIT_SWORD);
        HashMap map = Maps.newHashMap();
        if (this.m_9236_().m_46791_() == Difficulty.HARD) {
            map.put(Enchantments.f_44977_, 1);
        }
        map.put(Enchantments.f_44986_, 1);
        EnchantmentHelper.m_44865_((Map)map, (ItemStack)desertBanditSword);
        this.m_8061_(EquipmentSlot.MAINHAND, desertBanditSword);
        this.m_6844_(EquipmentSlot.MAINHAND).m_41714_((Component)Component.m_237115_((String)"equipment.betterdefaultbiomes.bandit_sword").m_130940_(ChatFormatting.YELLOW));
        float armorDropChance = DesertBanditEntity.armorDropChance;
        this.m_21409_(EquipmentSlot.MAINHAND, armorDropChance);
    }
}

