/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.configuration.entity.breeding;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import xratedjunior.betterdefaultbiomes.BetterDefaultBiomes;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingItem;

public class BreedingConfigRegistry {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final File breedingConfigDirectory = new File(BetterDefaultBiomes.BDBFolderPath.toFile() + "/food");
    public static final Map<String, BreedingConfig> BREEDING_CONFIGS = new HashMap<String, BreedingConfig>();
    public static final String CAMEL_FOOD = "camel_food";
    public static final String DUCK_FOOD = "duck_food";
    public static final String ZEBRA_FOOD = "zebra_food";
    public static final String FROG_FOOD = "frog_food";

    public static void constructBreedingConfigs() {
        BetterDefaultBiomes.LOGGER.debug("Constructing Breeding Config Files");
        ArrayList<BreedingConfig> breedingConfigs = new ArrayList<BreedingConfig>();
        breedingConfigs.add(new BreedingConfig(CAMEL_FOOD, Lists.newArrayList((Object[])new BreedingItem[]{new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42405_), true, 2, 20), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42129_), true, 20, 180), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42501_), false, 1, 30), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42410_), false, 3, 60), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42619_), false, 3, 60), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42677_), false, 4, 60), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42436_), false, 10, 240), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42437_), false, 20, 240)})));
        breedingConfigs.add(new BreedingConfig(DUCK_FOOD, Lists.newArrayList((Object[])new BreedingItem[]{new BreedingItem(BreedingConfigRegistry.getTagName((TagKey<Item>)Tags.Items.SEEDS), true, 1, 30), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42780_), true, 1, 40)})));
        breedingConfigs.add(new BreedingConfig(ZEBRA_FOOD, Lists.newArrayList((Object[])new BreedingItem[]{new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42405_), true, 2, 20), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42129_), true, 20, 180), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42501_), false, 1, 30), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42410_), false, 3, 60), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42619_), false, 3, 60), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42677_), false, 4, 60), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42436_), false, 10, 240), new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42437_), false, 20, 240)})));
        breedingConfigs.add(new BreedingConfig(FROG_FOOD, Lists.newArrayList((Object[])new BreedingItem[]{new BreedingItem(BreedingConfigRegistry.getItemName(Items.f_42591_), true, 2, 40)})));
        if (!breedingConfigDirectory.exists()) {
            breedingConfigDirectory.mkdirs();
            for (BreedingConfig breedingConfig : breedingConfigs) {
                BreedingConfigRegistry.generateJsonFile(breedingConfig);
            }
            return;
        }
        for (File file : breedingConfigDirectory.listFiles()) {
            String fileName = file.getName();
            if (fileName.endsWith(".json")) {
                try (FileReader json = new FileReader(file);){
                    BreedingConfig breedingConfig = (BreedingConfig)GSON.fromJson((Reader)json, BreedingConfig.class);
                    if (breedingConfig != null) {
                        if (BreedingConfigRegistry.isValid(breedingConfig)) {
                            BREEDING_CONFIGS.put(breedingConfig.getName(), breedingConfig);
                            for (int i = 0; i < breedingConfigs.size(); ++i) {
                                if (!((BreedingConfig)breedingConfigs.get(i)).getName().equals(breedingConfig.getName())) continue;
                                breedingConfigs.remove(i);
                            }
                        }
                        continue;
                    }
                    BetterDefaultBiomes.LOGGER.error("Could not load breeding entry from \"{}\".", (Object)fileName);
                }
                catch (Exception e) {
                    BetterDefaultBiomes.LOGGER.error("Unable to load file \"{}\". Please make sure it's a valid json.", (Object)fileName);
                    BetterDefaultBiomes.LOGGER.catching((Throwable)e);
                }
                continue;
            }
            BetterDefaultBiomes.LOGGER.error("Found invalid file \"{}\" in the BetterDefaultBiomes folder in the configs. It must be a .json file!", (Object)fileName);
        }
        if (!breedingConfigs.isEmpty()) {
            for (BreedingConfig breedingConfig : breedingConfigs) {
                BreedingConfigRegistry.generateJsonFile(breedingConfig);
            }
        }
        BetterDefaultBiomes.LOGGER.debug("Done constructing Breeding Config Files");
    }

    private static String getItemName(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item).toString();
    }

    private static String getTagName(TagKey<Item> itemTag) {
        return "tag:" + itemTag.f_203868_().toString();
    }

    private static void generateJsonFile(BreedingConfig breedingConfig) {
        try (FileWriter writer = new FileWriter(new File(breedingConfigDirectory, breedingConfig.getName() + ".json"));){
            GSON.toJson((Object)breedingConfig, (Appendable)writer);
            writer.flush();
            BREEDING_CONFIGS.put(breedingConfig.getName(), breedingConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static boolean isValid(BreedingConfig breedingConfig) {
        boolean foundErrors = false;
        if (breedingConfig.getBreedingItems().isEmpty()) {
            foundErrors = true;
            BetterDefaultBiomes.LOGGER.error("\"{}\" errored. No valid Items.", (Object)breedingConfig.getName());
        }
        return !foundErrors;
    }

    public static List<Item> getItemList(BreedingItem input) {
        String itemName = input.getItemName();
        ArrayList<Item> items = new ArrayList<Item>();
        String[] parts = itemName.split(":");
        if (parts.length > 0) {
            if (parts[0].equalsIgnoreCase("tag") && parts.length == 3) {
                ITag tagContents;
                ResourceLocation tagLocation = new ResourceLocation(parts[1], parts[2]);
                TagKey tagkey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLocation);
                if (ForgeRegistries.ITEMS.tags().isKnownTagName(tagkey) && !(tagContents = ForgeRegistries.ITEMS.tags().getTag(tagkey)).isEmpty()) {
                    for (Item item : tagContents) {
                        items.add(item);
                    }
                }
            } else if (parts.length > 1) {
                ResourceLocation itemLocation = new ResourceLocation(parts[0], parts[1]);
                Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
                if (item != null) {
                    items.add(item);
                } else {
                    BetterDefaultBiomes.LOGGER.error("Couldn't find an Item for \"{}\".", (Object)itemName);
                }
            }
        }
        return items;
    }

    public static List<ItemStack> getTemptationItemStacks(String breedingConfigName) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        BreedingConfig breedingConfig = BREEDING_CONFIGS.get(breedingConfigName);
        for (BreedingItem breedingItem : breedingConfig.getBreedingItems()) {
            List<Item> itemList = BreedingConfigRegistry.getItemList(breedingItem);
            for (Item item : itemList) {
                itemStackList.add(new ItemStack((ItemLike)item));
            }
        }
        if (itemStackList.isEmpty()) {
            // empty if block
        }
        return itemStackList;
    }

    public static List<ItemStack> getBreedingItemStacks(String breedingConfigName) {
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        BreedingConfig breedingConfig = BREEDING_CONFIGS.get(breedingConfigName);
        for (BreedingItem breedingItem : breedingConfig.getBreedingItems()) {
            if (!breedingItem.getBreeding()) continue;
            List<Item> itemList = BreedingConfigRegistry.getItemList(breedingItem);
            for (Item item : itemList) {
                itemStackList.add(new ItemStack((ItemLike)item));
            }
        }
        return itemStackList;
    }
}

