/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes.block.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.grower.AbstractTreeGrower;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.block.block.SimpleBlock;
import xratedjunior.betterdefaultbiomes.sound.BDBSoundEvents;

public class PineconeBlock
extends SimpleBlock
implements BonemealableBlock {
    private static final Random RANDOM = new Random();
    public static final BooleanProperty SIDEWAYS = BooleanProperty.m_61465_((String)"sideways");
    private static final VoxelShape PINECONE = PineconeBlock.makeSquareShape(6.0, 4.0);
    private final AbstractTreeGrower treeGrower;

    public PineconeBlock(AbstractTreeGrower treeGrower, BlockBehaviour.Properties properties) {
        super(properties);
        this.treeGrower = treeGrower;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)SIDEWAYS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext selectionContext) {
        Vec3 vector3d = state.m_60824_(worldIn, pos);
        return PINECONE.m_83216_(vector3d.f_82479_, vector3d.f_82480_, vector3d.f_82481_);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SIDEWAYS});
    }

    @Override
    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos groundPos = pos.m_7495_();
        BlockState groundBlock = worldIn.m_8055_(groundPos);
        return super.m_7898_(state, worldIn, pos) || groundBlock.m_60734_() instanceof LeavesBlock;
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState blockstate = super.m_5573_(context);
        if (blockstate != null && !context.m_43725_().m_5776_()) {
            int i = RANDOM.nextInt(6);
            return (BlockState)blockstate.m_61124_((Property)SIDEWAYS, (Comparable)Boolean.valueOf(i == 0));
        }
        return blockstate;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        boolean swingArm = false;
        ItemStack itemStackInHand = player.m_21120_(handIn);
        Item itemInHand = itemStackInHand.m_41720_();
        if (itemInHand == ((Block)BDBBlocks.PINECONE.get()).m_5456_()) {
            SoundType sound = this.getSoundType(state, (LevelReader)worldIn, pos, (Entity)player);
            worldIn.m_5594_(player, pos, (SoundEvent)BDBSoundEvents.BLOCK_SMALL_ROTATE.get(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
            if (((Boolean)state.m_61143_((Property)SIDEWAYS)).booleanValue()) {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)SIDEWAYS, (Comparable)Boolean.valueOf(false)));
                swingArm = true;
            } else {
                worldIn.m_46597_(pos, (BlockState)state.m_61124_((Property)SIDEWAYS, (Comparable)Boolean.valueOf(true)));
                swingArm = true;
            }
        } else if (itemInHand != Items.f_42499_) {
            swingArm = super.m_6227_(state, worldIn, pos, player, handIn, hit) == InteractionResult.SUCCESS;
        }
        return swingArm ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public boolean m_7370_(LevelReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        return true;
    }

    public boolean m_214167_(Level worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        BlockState blockStateBelow = worldIn.m_8055_(pos.m_7495_());
        if (blockStateBelow.m_204336_(BlockTags.f_144274_) || blockStateBelow.m_60713_(Blocks.f_50093_)) {
            return (double)rand.m_188501_() < 0.45;
        }
        return false;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        this.treeGrower.m_213817_(worldIn, worldIn.m_7726_().m_8481_(), pos, state, rand);
    }
}

