/*
 * Decompiled with CFR 0.152.
 */
package xratedjunior.betterdefaultbiomes;

import java.io.File;
import java.nio.file.Path;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xratedjunior.betterdefaultbiomes.BDBCreativeModeTabs;
import xratedjunior.betterdefaultbiomes.block.BDBBlocks;
import xratedjunior.betterdefaultbiomes.block.property.BDBWoodTypes;
import xratedjunior.betterdefaultbiomes.compat.BDBVanillaCompat;
import xratedjunior.betterdefaultbiomes.configuration.BDBModConfig;
import xratedjunior.betterdefaultbiomes.configuration.entity.breeding.BreedingConfigRegistry;
import xratedjunior.betterdefaultbiomes.configuration.extra.InfoFileEventHandler;
import xratedjunior.betterdefaultbiomes.datagen.BDBDataGenerators;
import xratedjunior.betterdefaultbiomes.enchantment.BDBEnchantments;
import xratedjunior.betterdefaultbiomes.enchantment.EnchantmentEventSubscriber;
import xratedjunior.betterdefaultbiomes.entity.BDBEntityTypes;
import xratedjunior.betterdefaultbiomes.entity.event.GlowingEntitiesEvent;
import xratedjunior.betterdefaultbiomes.entity.projectile.dispenser.CustomDispenserBehavior;
import xratedjunior.betterdefaultbiomes.item.BDBItems;
import xratedjunior.betterdefaultbiomes.item.FuelEventHandler;
import xratedjunior.betterdefaultbiomes.loot.BDBGlobalLootModifiers;
import xratedjunior.betterdefaultbiomes.proxy.ClientProxy;
import xratedjunior.betterdefaultbiomes.proxy.CommonProxy;
import xratedjunior.betterdefaultbiomes.sound.BDBSoundEvents;
import xratedjunior.betterdefaultbiomes.trade.BDBVillagerTradesEvent;
import xratedjunior.betterdefaultbiomes.world.BDBBiomeModifiers;
import xratedjunior.betterdefaultbiomes.world.generation.BDBFeatures;
import xratedjunior.betterdefaultbiomes.world.generation.BDBPlacementModifierTypes;

@Mod(value="betterdefaultbiomes")
public class BetterDefaultBiomes {
    public static final String MOD_ID = "betterdefaultbiomes";
    public static final Logger LOGGER = LogManager.getLogger((String)"betterdefaultbiomes");
    private static final String BDBFolderName = "betterdefaultbiomes";
    private static final File BDBFolder = new File(FMLPaths.CONFIGDIR.get().toFile(), "betterdefaultbiomes");
    public static final Path BDBFolderPath = BDBFolder.toPath();
    public static CommonProxy proxy = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);

    public BetterDefaultBiomes() {
        if (!BDBFolder.exists()) {
            BDBFolder.mkdirs();
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)BDBModConfig.COMMON_SPEC, "betterdefaultbiomes/betterdefaultbiomes.toml");
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BDBEnchantments.DEFERRED_ENCHANTMENTS.register(modEventBus);
        BDBSoundEvents.DEFERRED_SOUND_EVENTS.register(modEventBus);
        BDBBlocks.DEFERRED_BLOCKS.register(modEventBus);
        BDBItems.DEFERRED_ITEMS.register(modEventBus);
        BDBEntityTypes.DEFERRED_ENTITY_TYPES.register(modEventBus);
        BDBFeatures.DEFERRED_FEATURES.register(modEventBus);
        BDBPlacementModifierTypes.DEFERRED_PLACEMENT_MODIFIER_TYPES.register(modEventBus);
        BDBBiomeModifiers.DEFERRED_BIOME_MODIFIER_SERIALIZERS.register(modEventBus);
        BDBGlobalLootModifiers.DEFERRED_GLOBAL_LOOT_MODIFIER_SERIALIZERS.register(modEventBus);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::loadComplete);
        modEventBus.addListener(BDBDataGenerators::gatherData);
        modEventBus.addListener(BDBCreativeModeTabs::registerCreativeModeTabs);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        Sheets.addWoodType((WoodType)BDBWoodTypes.PALM);
        Sheets.addWoodType((WoodType)BDBWoodTypes.SWAMP_WILLOW);
        LOGGER.debug("clientSetup method completed");
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new GlowingEntitiesEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BDBVillagerTradesEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FuelEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new InfoFileEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new EnchantmentEventSubscriber());
        event.enqueueWork(() -> {
            LOGGER.debug("Starting common work queue");
            BreedingConfigRegistry.constructBreedingConfigs();
            FuelEventHandler.registerFuels();
            BDBVanillaCompat.setup();
            CustomDispenserBehavior.init();
            LOGGER.debug("Register Potted Plants");
            BDBBlocks.POTTED_PLANTS.forEach((flower, pottedFlower) -> ((FlowerPotBlock)Blocks.f_50276_).addPlant(ForgeRegistries.BLOCKS.getKey((Object)((Block)flower.get())), pottedFlower));
        });
        LOGGER.debug("commonSetup method completed");
    }

    private void loadComplete(FMLLoadCompleteEvent event) {
        proxy.init();
        LOGGER.debug("loadComplete method completed");
    }

    public static ResourceLocation locate(String name) {
        return new ResourceLocation("betterdefaultbiomes", name);
    }

    public static String find(String key) {
        return new String("betterdefaultbiomes:" + key);
    }
}

