/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.perk.types;

import com.aetherteam.aether.api.AetherMoaTypes;
import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.perk.PerkUtil;
import com.aetherteam.nitrogen.api.users.User;
import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.RegistryObject;

public class MoaSkins {
    private static final Map<String, MoaSkin> MOA_SKINS = new LinkedHashMap<String, MoaSkin>();

    public static void registerMoaSkins() {
        for (MoaType moaType : AetherMoaTypes.MOA_TYPES.getEntries().stream().map(RegistryObject::get).toList()) {
            String name = (moaType.getId().m_135827_().equals("aether") ? moaType.getId().m_135815_() : moaType.getId().toString().replace(":", ".")) + "_moa";
            MoaSkins.register(name, new MoaSkin(name, new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)("gui.aether.moa_skins.skin." + name))).userPredicate(user -> PerkUtil.hasHumanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/" + name + "_icon.png")).skinLocation(moaType.getMoaTexture()).saddleLocation(moaType.getSaddleTexture()).info(new MoaSkin.Info(User.Tier.HUMAN, false))));
        }
        MoaSkins.register("orange_moa", new MoaSkin("orange_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.orange_moa")).userPredicate(user -> PerkUtil.hasHumanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/orange_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/orange_moa/orange_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/moa_saddle.png")).info(new MoaSkin.Info(User.Tier.HUMAN, false))));
        MoaSkins.register("brown_moa", new MoaSkin("brown_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.brown_moa")).userPredicate(user -> PerkUtil.hasHumanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/brown_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/brown_moa/brown_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/black_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.HUMAN, false))));
        MoaSkins.register("red_moa", new MoaSkin("red_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.red_moa")).userPredicate(user -> PerkUtil.hasHumanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/red_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/red_moa/red_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/moa_saddle.png")).info(new MoaSkin.Info(User.Tier.HUMAN, false))));
        MoaSkins.register("green_moa", new MoaSkin("green_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.green_moa")).userPredicate(user -> PerkUtil.hasHumanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/green_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/green_moa/green_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/moa_saddle.png")).info(new MoaSkin.Info(User.Tier.HUMAN, false))));
        MoaSkins.register("purple_moa", new MoaSkin("purple_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.purple_moa")).userPredicate(user -> PerkUtil.hasHumanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/purple_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/purple_moa/purple_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/moa_saddle.png")).info(new MoaSkin.Info(User.Tier.HUMAN, false))));
        MoaSkins.register("boko_yellow", new MoaSkin("boko_yellow", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.boko_yellow")).userPredicate(user -> PerkUtil.hasLifetimeAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/boko_yellow_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/boko_yellow/boko_yellow.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/boko_yellow/boko_yellow_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/boko_yellow/boko_yellow_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, true))));
        MoaSkins.register("crookjaw_purple", new MoaSkin("crookjaw_purple", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.crookjaw_purple")).userPredicate(user -> PerkUtil.hasLifetimeAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/crookjaw_purple_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/crookjaw_purple/crookjaw_purple.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/crookjaw_purple/crookjaw_purple_emissive.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/crookjaw_purple/crookjaw_purple_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/crookjaw_purple/crookjaw_purple_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, true))));
        MoaSkins.register("gharrix_red", new MoaSkin("gharrix_red", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.gharrix_red")).userPredicate(user -> PerkUtil.hasLifetimeAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/gharrix_red_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/gharrix_red/gharrix_red.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/gharrix_red/gharrix_red_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, true))));
        MoaSkins.register("halcian_pink", new MoaSkin("halcian_pink", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.halcian_pink")).userPredicate(user -> PerkUtil.hasLifetimeAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/halcian_pink_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/halcian_pink/halcian_pink.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/halcian_pink/halcian_pink_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/halcian_pink/halcian_pink_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, true))));
        MoaSkins.register("tivalier_green", new MoaSkin("tivalier_green", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.tivalier_green")).userPredicate(user -> PerkUtil.hasLifetimeAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/tivalier_green_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/tivalier_green/tivalier_green.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/tivalier_green/tivalier_green_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, true))));
        MoaSkins.register("gilded_gharrix", new MoaSkin("gilded_gharrix", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.gilded_gharrix")).userPredicate(user -> PerkUtil.hasAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/gilded_gharrix_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/gilded_gharrix/gilded_gharrix.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/gilded_gharrix/gilded_gharrix_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/gilded_gharrix/gilded_gharrix_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, false))));
        MoaSkins.register("gargoyle_moa", new MoaSkin("gargoyle_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.gargoyle_moa")).userPredicate(user -> PerkUtil.hasAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/gargoyle_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/gargoyle_moa/gargoyle_moa.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/gargoyle_moa/gargoyle_moa_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/gargoyle_moa/gargoyle_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, false))));
        MoaSkins.register("construction_bot", new MoaSkin("construction_bot", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.construction_bot")).userPredicate(user -> PerkUtil.hasAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/construction_bot_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/construction_bot/construction_bot.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/construction_bot/construction_bot_hat.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/construction_bot/construction_bot_emissive.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/construction_bot/construction_bot_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, false))));
        MoaSkins.register("mossy_statue_moa", new MoaSkin("mossy_statue_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.mossy_statue_moa")).userPredicate(user -> PerkUtil.hasAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/mossy_statue_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/mossy_statue_moa/mossy_statue_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/mossy_statue_moa/mossy_statue_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, false))));
        MoaSkins.register("chicken_moa", new MoaSkin("chicken_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.chicken_moa")).userPredicate(user -> PerkUtil.hasAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/chicken_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/chicken_moa/chicken_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/chicken_moa/chicken_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, false))));
        MoaSkins.register("medical_bot", new MoaSkin("medical_bot", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.medical_bot")).userPredicate(user -> PerkUtil.hasAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/medical_bot_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/medical_bot/medical_bot.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/medical_bot/medical_bot_emissive.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/medical_bot/medical_bot_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/medical_bot/medical_bot_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, false))));
        MoaSkins.register("skeleton_moa", new MoaSkin("skeleton_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.skeleton_moa")).userPredicate(user -> PerkUtil.hasAscentanMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/skeleton_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/skeleton_moa/skeleton_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/skeleton_moa/skeleton_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.ASCENTAN, false))));
        MoaSkins.register("arctic_moa", new MoaSkin("arctic_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.arctic_moa")).userPredicate(user -> PerkUtil.hasLifetimeValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/arctic_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/arctic_moa/arctic_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/arctic_moa/arctic_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, true))));
        MoaSkins.register("cockatrice_moa", new MoaSkin("cockatrice_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.cockatrice_moa")).userPredicate(user -> PerkUtil.hasLifetimeValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/cockatrice_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/cockatrice_moa/cockatrice_moa.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/cockatrice_moa/cockatrice_moa_emissive.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/cockatrice_moa/cockatrice_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, true))));
        MoaSkins.register("phoenix_moa", new MoaSkin("phoenix_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.phoenix_moa")).userPredicate(user -> PerkUtil.hasLifetimeValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/phoenix_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/phoenix_moa/phoenix_moa.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/phoenix_moa/phoenix_moa_emissive.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/phoenix_moa/phoenix_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, true))));
        MoaSkins.register("sentry_moa", new MoaSkin("sentry_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.sentry_moa")).userPredicate(user -> PerkUtil.hasLifetimeValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/sentry_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/sentry_moa/sentry_moa.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/sentry_moa/sentry_moa_emissive.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/sentry_moa/sentry_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, true))));
        MoaSkins.register("valkyrie_moa", new MoaSkin("valkyrie_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.valkyrie_moa")).userPredicate(user -> PerkUtil.hasLifetimeValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/valkyrie_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/valkyrie_moa/valkyrie_moa.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/valkyrie_moa/valkyrie_moa_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/valkyrie_moa/valkyrie_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, true))));
        MoaSkins.register("battle_sentry_moa", new MoaSkin("battle_sentry_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.battle_sentry_moa")).userPredicate(user -> PerkUtil.hasValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/battle_sentry_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/battle_sentry_moa/battle_sentry_moa.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/battle_sentry_moa/battle_sentry_moa_emissive.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/battle_sentry_moa/battle_sentry_moa_hat.png")).hatEmissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/battle_sentry_moa/battle_sentry_moa_hat_emissive.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/battle_sentry_moa/battle_sentry_moa_saddle.png")).saddleEmissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/battle_sentry_moa/battle_sentry_moa_saddle_emissive.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, false))));
        MoaSkins.register("frozen_phoenix", new MoaSkin("frozen_phoenix", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.frozen_phoenix")).userPredicate(user -> PerkUtil.hasValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/frozen_phoenix_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/frozen_phoenix/frozen_phoenix.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/frozen_phoenix/frozen_phoenix_emissive.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/frozen_phoenix/frozen_phoenix_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, false))));
        MoaSkins.register("molten_moa", new MoaSkin("molten_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.molten_moa")).userPredicate(user -> PerkUtil.hasValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/molten_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/molten_moa/molten_moa.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/molten_moa/molten_moa_emissive.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/molten_moa/molten_moa_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/molten_moa/molten_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, false))));
        MoaSkins.register("undead_moa", new MoaSkin("undead_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.undead_moa")).userPredicate(user -> PerkUtil.hasValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/undead_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/undead_moa/undead_moa.png")).emissiveLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/undead_moa/undead_moa_emissive.png")).hatLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/undead_moa/undead_moa_hat.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/undead_moa/undead_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, false))));
        MoaSkins.register("stratus", new MoaSkin("stratus", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.stratus")).userPredicate(user -> PerkUtil.hasValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/stratus_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/stratus/stratus.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/stratus/stratus_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, false))));
        MoaSkins.register("peacock_moa", new MoaSkin("peacock_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.peacock_moa")).userPredicate(user -> PerkUtil.hasValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/peacock_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/peacock_moa/peacock_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/peacock_moa/peacock_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, false))));
        MoaSkins.register("prehistoric_moa", new MoaSkin("prehistoric_moa", new MoaSkin.Properties().displayName((Component)Component.m_237115_((String)"gui.aether.moa_skins.skin.prehistoric_moa")).userPredicate(user -> PerkUtil.hasValkyrieMoaSkins().test((User)user)).iconLocation(new ResourceLocation("aether", "textures/gui/perks/skins/icons/prehistoric_moa_icon.png")).skinLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/prehistoric_moa/prehistoric_moa.png")).saddleLocation(new ResourceLocation("aether", "textures/entity/mobs/moa/skins/prehistoric_moa/prehistoric_moa_saddle.png")).info(new MoaSkin.Info(User.Tier.VALKYRIE, false))));
    }

    private static void register(String id, MoaSkin moaSkin) {
        MOA_SKINS.put(id, moaSkin);
    }

    public static Map<String, MoaSkin> getMoaSkins() {
        return ImmutableMap.copyOf(MOA_SKINS);
    }

    public static class MoaSkin {
        private final String id;
        private final Component displayName;
        private final Predicate<User> userPredicate;
        private final ResourceLocation iconLocation;
        private final ResourceLocation skinLocation;
        @Nullable
        private final ResourceLocation emissiveLocation;
        @Nullable
        private final ResourceLocation hatLocation;
        @Nullable
        private final ResourceLocation hatEmissiveLocation;
        private final ResourceLocation saddleLocation;
        @Nullable
        private final ResourceLocation saddleEmissiveLocation;
        private final Info info;

        protected MoaSkin(String id, Properties properties) {
            this(id, properties.displayName, properties.userPredicate, properties.iconLocation, properties.skinLocation, properties.emissiveLocation, properties.hatLocation, properties.hatEmissiveLocation, properties.saddleLocation, properties.saddleEmissiveLocation, properties.info);
        }

        protected MoaSkin(String id, Component displayName, Predicate<User> userPredicate, ResourceLocation iconLocation, ResourceLocation skinLocation, ResourceLocation emissiveLocation, ResourceLocation hatLocation, ResourceLocation hatEmissiveLocation, ResourceLocation saddleLocation, ResourceLocation saddleEmissiveLocation, Info info) {
            this.id = id;
            this.displayName = displayName;
            this.userPredicate = userPredicate;
            this.iconLocation = iconLocation;
            this.skinLocation = skinLocation;
            this.emissiveLocation = emissiveLocation;
            this.hatLocation = hatLocation;
            this.hatEmissiveLocation = hatEmissiveLocation;
            this.saddleLocation = saddleLocation;
            this.saddleEmissiveLocation = saddleEmissiveLocation;
            this.info = info;
        }

        public String getId() {
            return this.id;
        }

        public Component getDisplayName() {
            return this.displayName;
        }

        public Predicate<User> getUserPredicate() {
            return this.userPredicate;
        }

        public ResourceLocation getIconLocation() {
            return this.iconLocation;
        }

        public ResourceLocation getSkinLocation() {
            return this.skinLocation;
        }

        @Nullable
        public ResourceLocation getEmissiveLocation() {
            return this.emissiveLocation;
        }

        public ResourceLocation getHatLocation() {
            return this.hatLocation;
        }

        public ResourceLocation getHatEmissiveLocation() {
            return this.hatEmissiveLocation;
        }

        public ResourceLocation getSaddleLocation() {
            return this.saddleLocation;
        }

        @Nullable
        public ResourceLocation getSaddleEmissiveLocation() {
            return this.saddleEmissiveLocation;
        }

        public Info getInfo() {
            return this.info;
        }

        public static MoaSkin read(FriendlyByteBuf buffer) {
            String id = buffer.m_130277_();
            return MoaSkins.getMoaSkins().get(id);
        }

        public static void write(FriendlyByteBuf buffer, MoaSkin moaSkin) {
            buffer.m_130070_(moaSkin.getId());
        }

        public static class Properties {
            private Component displayName;
            private Predicate<User> userPredicate;
            private ResourceLocation iconLocation;
            private ResourceLocation skinLocation;
            @Nullable
            private ResourceLocation emissiveLocation = null;
            @Nullable
            private ResourceLocation hatLocation = null;
            @Nullable
            private ResourceLocation hatEmissiveLocation = null;
            private ResourceLocation saddleLocation;
            @Nullable
            private ResourceLocation saddleEmissiveLocation = null;
            private Info info;

            public Properties displayName(Component displayName) {
                this.displayName = displayName;
                return this;
            }

            public Properties userPredicate(Predicate<User> userPredicate) {
                this.userPredicate = userPredicate;
                return this;
            }

            public Properties iconLocation(ResourceLocation iconLocation) {
                this.iconLocation = iconLocation;
                return this;
            }

            public Properties skinLocation(ResourceLocation skinLocation) {
                this.skinLocation = skinLocation;
                return this;
            }

            public Properties emissiveLocation(@Nullable ResourceLocation emissiveLocation) {
                this.emissiveLocation = emissiveLocation;
                return this;
            }

            public Properties hatLocation(ResourceLocation hatLocation) {
                this.hatLocation = hatLocation;
                return this;
            }

            public Properties hatEmissiveLocation(ResourceLocation hatEmissiveLocation) {
                this.hatEmissiveLocation = hatEmissiveLocation;
                return this;
            }

            public Properties saddleLocation(ResourceLocation saddleLocation) {
                this.saddleLocation = saddleLocation;
                return this;
            }

            public Properties saddleEmissiveLocation(ResourceLocation saddleEmissiveLocation) {
                this.saddleEmissiveLocation = saddleEmissiveLocation;
                return this;
            }

            public Properties info(Info info) {
                this.info = info;
                return this;
            }
        }

        public record Info(User.Tier tier, boolean lifetime) {
        }
    }
}

