/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.loot.modifiers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class GlovesLootModifier
extends LootModifier {
    public static final Codec<GlovesLootModifier> CODEC = RecordCodecBuilder.create(instance -> GlovesLootModifier.codecStart((RecordCodecBuilder.Instance)instance).and((App)ItemStack.f_41582_.fieldOf("gloves").forGetter(modifier -> modifier.glovesStack)).and((App)ArmorMaterials.f_265935_.fieldOf("armor_material").forGetter(modifier -> modifier.armorMaterial)).apply((Applicative)instance, GlovesLootModifier::new));
    public final ItemStack glovesStack;
    public final ArmorMaterials armorMaterial;

    public GlovesLootModifier(LootItemCondition[] conditionsIn, ItemStack glovesStack, ArmorMaterials armorMaterial) {
        super(conditionsIn);
        this.glovesStack = glovesStack;
        this.armorMaterial = armorMaterial;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> lootStacks, LootContext context) {
        RandomSource randomSource = context.m_230907_();
        Vec3 vec3 = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (vec3 != null) {
            BlockPos pos = BlockPos.m_274446_((Position)vec3);
            BlockEntity blockEntity = context.m_78952_().m_7702_(pos);
            if (blockEntity instanceof BaseContainerBlockEntity) {
                List<ItemStack> armorItems = lootStacks.stream().filter(itemStack -> {
                    ArmorItem armorItem;
                    Item patt3092$temp = itemStack.m_41720_();
                    return patt3092$temp instanceof ArmorItem && (armorItem = (ArmorItem)patt3092$temp).m_40401_().equals(this.armorMaterial);
                }).toList();
                for (ItemStack armorStack : armorItems) {
                    if (randomSource.m_188503_(4) >= 1) continue;
                    ItemStack gloves = this.glovesStack.m_41777_();
                    int cost = 0;
                    boolean isTreasure = false;
                    for (Map.Entry enchantmentInfo : armorStack.getAllEnchantments().entrySet()) {
                        Enchantment enchantment = (Enchantment)enchantmentInfo.getKey();
                        int level = (Integer)enchantmentInfo.getValue();
                        cost = Math.max(cost, enchantment.m_6183_(level));
                        if (!isTreasure) {
                            isTreasure = enchantment.m_6591_();
                        }
                        if (!gloves.canApplyAtEnchantingTable(enchantment)) continue;
                        gloves.m_41663_(enchantment, ((Integer)enchantmentInfo.getValue()).intValue());
                    }
                    if (!armorStack.getAllEnchantments().isEmpty() && gloves.getAllEnchantments().isEmpty()) {
                        EnchantmentHelper.m_220292_((RandomSource)randomSource, (ItemStack)gloves, (int)cost, (boolean)isTreasure);
                    }
                    if (!armorStack.getAllEnchantments().isEmpty() && gloves.getAllEnchantments().isEmpty()) continue;
                    lootStacks.replaceAll(stack -> stack.equals(armorStack) ? gloves : stack);
                }
            }
        }
        return lootStacks;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

