/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.accessories.cape.CapeItem;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModList;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public final class EquipmentUtil {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isFullStrength(LivingEntity attacker) {
        boolean combatifyLoaded = ModList.get().isLoaded("combatify");
        if (!(attacker instanceof Player)) return true;
        Player player = (Player)attacker;
        if (combatifyLoaded) {
            if (!(player.m_36403_(1.0f) >= 1.95f)) return false;
            return true;
        } else if (!(player.m_36403_(1.0f) >= 1.0f)) return false;
        return true;
    }

    public static double calculateZaniteBuff(ItemStack stack, double baseValue) {
        return baseValue * (2.0 * (double)stack.m_41773_() / (double)stack.m_41776_() + 0.5);
    }

    @Nullable
    public static SlotResult getGloves(LivingEntity entity) {
        Optional<SlotResult> slotResultOptional = EquipmentUtil.findFirstCurio(entity, (ItemStack stack) -> stack.m_41720_() instanceof GlovesItem);
        return slotResultOptional.orElse(null);
    }

    public static List<SlotResult> getZaniteRings(LivingEntity entity) {
        return EquipmentUtil.getCurios(entity, (Item)AetherItems.ZANITE_RING.get());
    }

    @Nullable
    public static SlotResult getZanitePendant(LivingEntity entity) {
        return EquipmentUtil.getCurio(entity, (Item)AetherItems.ZANITE_PENDANT.get());
    }

    public static boolean hasFreezingAccessory(LivingEntity entity) {
        return EquipmentUtil.hasCurio(entity, (Item)AetherItems.ICE_PENDANT.get()) || EquipmentUtil.hasCurio(entity, (Item)AetherItems.ICE_RING.get());
    }

    public static boolean hasSwetCape(LivingEntity entity) {
        return EquipmentUtil.hasCurio(entity, (Item)AetherItems.SWET_CAPE.get());
    }

    public static boolean hasInvisibilityCloak(LivingEntity entity) {
        return EquipmentUtil.hasCurio(entity, (Item)AetherItems.INVISIBILITY_CLOAK.get());
    }

    public static boolean hasCape(LivingEntity entity) {
        return EquipmentUtil.findFirstCurio(entity, (ItemStack stack) -> stack.m_41720_() instanceof CapeItem).isPresent();
    }

    @Nullable
    public static SlotResult getCape(LivingEntity entity) {
        return EquipmentUtil.findFirstCurio(entity, (ItemStack stack) -> stack.m_41720_() instanceof CapeItem).orElse(null);
    }

    public static boolean hasCurio(LivingEntity entity, Item item) {
        return EquipmentUtil.findFirstCurio(entity, item).isPresent();
    }

    @Nullable
    public static SlotResult getCurio(LivingEntity entity, Item item) {
        return EquipmentUtil.findFirstCurio(entity, item).orElse(null);
    }

    public static List<SlotResult> getCurios(LivingEntity entity, Item item) {
        LazyOptional inventoryOptional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (inventoryOptional.isPresent() && inventoryOptional.resolve().isPresent()) {
            ICuriosItemHandler inventory = (ICuriosItemHandler)inventoryOptional.resolve().get();
            return inventory.findCurios(item);
        }
        return List.of();
    }

    public static boolean hasSentryBoots(LivingEntity entity) {
        return entity.m_6844_(EquipmentSlot.FEET).m_150930_((Item)AetherItems.SENTRY_BOOTS.get());
    }

    public static boolean hasFullGravititeSet(LivingEntity entity) {
        return EquipmentUtil.hasArmorSet(entity, (Item)AetherItems.GRAVITITE_HELMET.get(), (Item)AetherItems.GRAVITITE_CHESTPLATE.get(), (Item)AetherItems.GRAVITITE_LEGGINGS.get(), (Item)AetherItems.GRAVITITE_BOOTS.get(), (Item)AetherItems.GRAVITITE_GLOVES.get());
    }

    public static boolean hasFullValkyrieSet(LivingEntity entity) {
        return EquipmentUtil.hasArmorSet(entity, (Item)AetherItems.VALKYRIE_HELMET.get(), (Item)AetherItems.VALKYRIE_CHESTPLATE.get(), (Item)AetherItems.VALKYRIE_LEGGINGS.get(), (Item)AetherItems.VALKYRIE_BOOTS.get(), (Item)AetherItems.VALKYRIE_GLOVES.get());
    }

    public static boolean hasFullNeptuneSet(LivingEntity entity) {
        return EquipmentUtil.hasArmorSet(entity, (Item)AetherItems.NEPTUNE_HELMET.get(), (Item)AetherItems.NEPTUNE_CHESTPLATE.get(), (Item)AetherItems.NEPTUNE_LEGGINGS.get(), (Item)AetherItems.NEPTUNE_BOOTS.get(), (Item)AetherItems.NEPTUNE_GLOVES.get());
    }

    public static boolean hasFullPhoenixSet(LivingEntity entity) {
        return EquipmentUtil.hasArmorSet(entity, (Item)AetherItems.PHOENIX_HELMET.get(), (Item)AetherItems.PHOENIX_CHESTPLATE.get(), (Item)AetherItems.PHOENIX_LEGGINGS.get(), (Item)AetherItems.PHOENIX_BOOTS.get(), (Item)AetherItems.PHOENIX_GLOVES.get());
    }

    public static boolean hasAnyPhoenixArmor(LivingEntity entity) {
        return EquipmentUtil.hasAnyArmor(entity, (Item)AetherItems.PHOENIX_HELMET.get(), (Item)AetherItems.PHOENIX_CHESTPLATE.get(), (Item)AetherItems.PHOENIX_LEGGINGS.get(), (Item)AetherItems.PHOENIX_BOOTS.get(), (Item)AetherItems.PHOENIX_GLOVES.get());
    }

    private static boolean hasArmorSet(LivingEntity entity, Item helmet, Item chestplate, Item leggings, Item boots, Item gloves) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_150930_(helmet) && entity.m_6844_(EquipmentSlot.CHEST).m_150930_(chestplate) && entity.m_6844_(EquipmentSlot.LEGS).m_150930_(leggings) && entity.m_6844_(EquipmentSlot.FEET).m_150930_(boots) && ((Boolean)AetherConfig.SERVER.require_gloves.get() == false || EquipmentUtil.findFirstCurio(entity, gloves).isPresent());
    }

    private static boolean hasAnyArmor(LivingEntity entity, Item helmet, Item chestplate, Item leggings, Item boots, Item gloves) {
        return entity.m_6844_(EquipmentSlot.HEAD).m_150930_(helmet) || entity.m_6844_(EquipmentSlot.CHEST).m_150930_(chestplate) || entity.m_6844_(EquipmentSlot.LEGS).m_150930_(leggings) || entity.m_6844_(EquipmentSlot.FEET).m_150930_(boots) || EquipmentUtil.findFirstCurio(entity, gloves).isPresent();
    }

    public static Optional<SlotResult> findFirstCurio(LivingEntity entity, Item item) {
        return EquipmentUtil.findFirstCurio(entity, (ItemStack itemStack) -> itemStack.m_150930_(item));
    }

    public static Optional<SlotResult> findFirstCurio(LivingEntity entity, Predicate<ItemStack> predicate) {
        LazyOptional inventoryOptional = CuriosApi.getCuriosInventory((LivingEntity)entity);
        if (inventoryOptional.isPresent() && inventoryOptional.resolve().isPresent()) {
            ICuriosItemHandler inventory = (ICuriosItemHandler)inventoryOptional.resolve().get();
            return inventory.findFirstCurio(predicate);
        }
        return Optional.empty();
    }
}

