/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.event.hooks;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.capability.accessory.MobAccessory;
import com.aetherteam.aether.capability.item.DroppedItem;
import com.aetherteam.aether.capability.lightning.LightningTracker;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.ai.goal.BeeGrowBerryBushGoal;
import com.aetherteam.aether.entity.ai.goal.FoxEatBerryBushGoal;
import com.aetherteam.aether.entity.monster.Swet;
import com.aetherteam.aether.entity.monster.dungeon.boss.Slider;
import com.aetherteam.aether.entity.monster.dungeon.boss.ValkyrieQueen;
import com.aetherteam.aether.entity.passive.FlyingCow;
import com.aetherteam.aether.entity.passive.MountableAnimal;
import com.aetherteam.aether.item.AetherItems;
import com.aetherteam.aether.item.accessories.AccessoryItem;
import com.aetherteam.aether.item.accessories.cape.CapeItem;
import com.aetherteam.aether.item.accessories.gloves.GlovesItem;
import com.aetherteam.aether.item.accessories.miscellaneous.ShieldOfRepulsionItem;
import com.aetherteam.aether.item.accessories.pendant.PendantItem;
import com.aetherteam.aether.item.miscellaneous.bucket.SkyrootBucketItem;
import com.aetherteam.aether.mixin.AetherMixinHooks;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.piglin.AbstractPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class EntityHooks {
    public static void addGoals(Entity entity) {
        if (entity.getClass() == Bee.class) {
            Bee bee = (Bee)entity;
            bee.m_148772_().m_25352_(7, (Goal)new BeeGrowBerryBushGoal(bee));
        } else if (entity.getClass() == Fox.class) {
            Fox fox = (Fox)entity;
            fox.f_21345_.m_25352_(10, (Goal)new FoxEatBerryBushGoal(fox, 1.2f, 12, 1));
        }
    }

    public static boolean canMobSpawnWithAccessories(Entity entity) {
        EntityType entityType = entity.m_6095_();
        return entity instanceof Mob && (entityType == EntityType.f_20501_ || entityType == EntityType.f_20530_ || entityType == EntityType.f_20458_ || entityType == EntityType.f_20524_ || entityType == EntityType.f_20481_ || entityType == EntityType.f_20511_);
    }

    public static void spawnWithAccessories(Entity entity, DifficultyInstance difficulty) {
        Mob mob;
        if (entity instanceof Mob && (mob = (Mob)entity).m_9236_() instanceof ServerLevel) {
            RandomSource random = mob.m_217043_();
            EntityType entityType = mob.m_6095_();
            String[] allSlots = new String[]{"hands", "necklace", "aether_gloves", "aether_pendant"};
            String[] gloveSlots = new String[]{"hands", "aether_gloves"};
            if (entityType == EntityType.f_20511_) {
                AbstractPiglin abstractPiglin;
                if (mob instanceof AbstractPiglin && (abstractPiglin = (AbstractPiglin)mob).m_34667_()) {
                    for (String identifier : allSlots) {
                        if (!(random.m_188501_() < 0.1f)) continue;
                        EntityHooks.equipAccessory(mob, identifier, ArmorMaterials.GOLD);
                    }
                }
            } else {
                ArmorItem armorItem;
                String[] stringArray;
                Item item;
                boolean fullyArmored = true;
                for (EquipmentSlot equipmentslot : EquipmentSlot.values()) {
                    ItemStack itemStack;
                    if (equipmentslot.m_20743_() != EquipmentSlot.Type.ARMOR || !(itemStack = mob.m_6844_(equipmentslot)).m_41619_()) continue;
                    fullyArmored = false;
                    break;
                }
                if (fullyArmored && random.m_188503_(4) == 1 && (item = mob.m_6844_(EquipmentSlot.CHEST).m_41720_()) instanceof ArmorItem && (stringArray = (armorItem = (ArmorItem)item).m_40401_()) instanceof ArmorMaterials) {
                    ArmorMaterials armorMaterials = (ArmorMaterials)stringArray;
                    for (String identifier : gloveSlots) {
                        EntityHooks.equipAccessory(mob, identifier, armorMaterials);
                    }
                }
            }
            EntityHooks.enchantAccessories(mob, difficulty, allSlots);
        }
    }

    private static void equipAccessory(Mob mob, String identifier, ArmorMaterials armorMaterials) {
        CuriosApi.getCuriosInventory((LivingEntity)mob).ifPresent(handler -> {
            Item item;
            boolean empty = true;
            for (SlotResult slotResult : handler.findCurios(new String[]{identifier})) {
                if (slotResult.stack().m_41619_()) continue;
                empty = false;
            }
            if (empty && (item = EntityHooks.getEquipmentForSlot(identifier, armorMaterials)) != null) {
                handler.setEquippedCurio(identifier, 0, new ItemStack((ItemLike)item));
            }
        });
    }

    @Nullable
    private static Item getEquipmentForSlot(String identifier, ArmorMaterials armorMaterials) {
        if (identifier.equals((Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "hands" : "aether_gloves")) {
            switch (armorMaterials) {
                case LEATHER: {
                    return (Item)AetherItems.LEATHER_GLOVES.get();
                }
                case GOLD: {
                    return (Item)AetherItems.GOLDEN_GLOVES.get();
                }
                case CHAIN: {
                    return (Item)AetherItems.CHAINMAIL_GLOVES.get();
                }
                case IRON: {
                    return (Item)AetherItems.IRON_GLOVES.get();
                }
                case DIAMOND: {
                    return (Item)AetherItems.DIAMOND_GLOVES.get();
                }
            }
        } else if (identifier.equals((Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "necklace" : "aether_pendant")) {
            switch (armorMaterials) {
                case GOLD: {
                    return (Item)AetherItems.GOLDEN_PENDANT.get();
                }
                case IRON: {
                    return (Item)AetherItems.IRON_PENDANT.get();
                }
            }
        }
        return null;
    }

    private static void enchantAccessories(Mob mob, DifficultyInstance difficulty, String[] allowedSlots) {
        RandomSource random = mob.m_217043_();
        float chanceMultiplier = difficulty.m_19057_();
        for (String identifier : allowedSlots) {
            CuriosApi.getCuriosInventory((LivingEntity)mob).ifPresent(handler -> handler.findCurio(identifier, 0).ifPresent(slotResult -> {
                ItemStack itemStack = slotResult.stack();
                if (!itemStack.m_41619_() && random.m_188501_() < 0.5f * chanceMultiplier) {
                    handler.setEquippedCurio(identifier, 0, EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)itemStack, (int)((int)(5.0f + chanceMultiplier * (float)random.m_188503_(18))), (boolean)false));
                }
            }));
        }
    }

    public static boolean dismountPrevention(Entity rider, Entity mount, boolean dismounting) {
        if (dismounting && rider.m_6144_()) {
            Swet swet;
            return mount instanceof MountableAnimal && !mount.m_20096_() && !mount.isInFluidType() && !mount.m_20159_() || mount instanceof Swet && !(swet = (Swet)mount).isFriendly();
        }
        return false;
    }

    public static void launchMount(Player player) {
        Entity mount = player.m_20202_();
        if (player.m_20159_() && mount != null && mount.m_9236_().m_45556_(mount.m_20191_()).anyMatch(state -> state.m_60713_((Block)AetherBlocks.BLUE_AERCLOUD.get())) && player.m_9236_().m_5776_()) {
            mount.m_20334_(mount.m_20184_().m_7096_(), 2.0, mount.m_20184_().m_7094_());
        }
    }

    public static void skyrootBucketMilking(Entity target, Player player, InteractionHand hand) {
        ItemStack heldStack;
        if ((target instanceof Cow || target instanceof FlyingCow) && !((Animal)target).m_6162_() && (heldStack = player.m_21120_(hand)).m_150930_((Item)AetherItems.SKYROOT_BUCKET.get())) {
            if (target instanceof FlyingCow) {
                player.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_FLYING_COW_MILK.get(), 1.0f, 1.0f);
            } else {
                player.m_5496_(SoundEvents.f_11833_, 1.0f, 1.0f);
            }
            ItemStack filledBucket = ItemUtils.m_41813_((ItemStack)heldStack, (Player)player, (ItemStack)((Item)AetherItems.SKYROOT_MILK_BUCKET.get()).m_7968_());
            player.m_6674_(hand);
            player.m_21008_(hand, filledBucket);
        }
    }

    public static Optional<InteractionResult> pickupBucketable(Entity target, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        Optional<InteractionResult> interactionResult = Optional.empty();
        if (heldStack.m_150930_((Item)AetherItems.SKYROOT_WATER_BUCKET.get()) && target instanceof Bucketable) {
            LivingEntity livingEntity;
            Bucketable bucketable = (Bucketable)target;
            if (target instanceof LivingEntity && (livingEntity = (LivingEntity)target).m_6084_()) {
                ItemStack bucketStack = bucketable.m_28282_();
                if (!(bucketStack = SkyrootBucketItem.swapBucketType(bucketStack)).m_41619_()) {
                    target.m_5496_(bucketable.m_142623_(), 1.0f, 1.0f);
                    bucketable.m_6872_(bucketStack);
                    ItemStack filledStack = ItemUtils.m_41817_((ItemStack)heldStack, (Player)player, (ItemStack)bucketStack, (boolean)false);
                    player.m_21008_(hand, filledStack);
                    Level level = livingEntity.m_9236_();
                    if (!level.m_5776_()) {
                        CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, bucketStack);
                    }
                    target.m_146870_();
                    interactionResult = Optional.of(InteractionResult.m_19078_((boolean)level.m_5776_()));
                } else {
                    interactionResult = Optional.of(InteractionResult.FAIL);
                }
            }
        }
        return interactionResult;
    }

    public static Optional<InteractionResult> interactWithArmorStand(Entity target, Player player, ItemStack stack, Vec3 pos, InteractionHand hand) {
        if (target instanceof ArmorStand) {
            ArmorStand armorStand = (ArmorStand)target;
            if (armorStand.m_9236_().m_5776_()) {
                return Optional.of(InteractionResult.SUCCESS);
            }
            if (!stack.m_41619_()) {
                if (stack.m_204117_(AetherTags.Items.ACCESSORIES)) {
                    IDynamicStackHandler stackHandler;
                    ICuriosItemHandler handler;
                    Optional stacksHandler;
                    String identifier = "";
                    if (stack.m_41720_() instanceof GlovesItem) {
                        identifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "hands" : "aether_gloves";
                    } else if (stack.m_41720_() instanceof PendantItem) {
                        identifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "necklace" : "aether_pendant";
                    } else if (stack.m_41720_() instanceof CapeItem) {
                        identifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "back" : "aether_cape";
                    } else if (stack.m_41720_() instanceof ShieldOfRepulsionItem) {
                        identifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "body" : "aether_shield";
                    }
                    LazyOptional lazyHandler = CuriosApi.getCuriosInventory((LivingEntity)armorStand);
                    if (lazyHandler.isPresent() && lazyHandler.resolve().isPresent() && (stacksHandler = (handler = (ICuriosItemHandler)lazyHandler.resolve().get()).getStacksHandler(identifier)).isPresent() && 0 < (stackHandler = ((ICurioStacksHandler)stacksHandler.get()).getCosmeticStacks()).getSlots()) {
                        SlotContext slotContext;
                        AccessoryItem accessoryItem;
                        ItemStack itemStack = stackHandler.getStackInSlot(0);
                        Item item = stack.m_41720_();
                        if (item instanceof AccessoryItem && (accessoryItem = (AccessoryItem)item).canEquip(slotContext = new SlotContext(identifier, (LivingEntity)armorStand, 0, true, true), stack)) {
                            stackHandler.setStackInSlot(0, stack.m_41777_());
                            if (accessoryItem instanceof GlovesItem) {
                                GlovesItem glovesItem = (GlovesItem)accessoryItem;
                                armorStand.m_9236_().m_5594_(null, armorStand.m_20183_(), glovesItem.getEquipSound(slotContext, stack).soundEvent(), armorStand.m_5720_(), 1.0f, 1.0f);
                            } else if (accessoryItem instanceof PendantItem) {
                                PendantItem pendantItem = (PendantItem)accessoryItem;
                                armorStand.m_9236_().m_5594_(null, armorStand.m_20183_(), pendantItem.getEquipSound(slotContext, stack).soundEvent(), armorStand.m_5720_(), 1.0f, 1.0f);
                            } else {
                                armorStand.m_9236_().m_5594_(null, armorStand.m_20183_(), SoundEvents.f_11675_, armorStand.m_5720_(), 1.0f, 1.0f);
                            }
                            if (identifier.equals("hands") || identifier.equals("aether_gloves")) {
                                armorStand.m_31675_(true);
                            }
                            if (!player.m_7500_()) {
                                int count = stack.m_41613_();
                                stack.m_41774_(count);
                            }
                            if (!itemStack.m_41619_()) {
                                player.m_21008_(hand, itemStack);
                            }
                            return Optional.of(InteractionResult.SUCCESS);
                        }
                    }
                }
            } else {
                ItemStack itemStack;
                IDynamicStackHandler stackHandler;
                ICuriosItemHandler handler;
                Optional stacksHandler;
                LazyOptional lazyHandler;
                String identifier = EntityHooks.slotToUnequip(armorStand, pos);
                if (!identifier.isEmpty() && (lazyHandler = CuriosApi.getCuriosInventory((LivingEntity)armorStand)).isPresent() && lazyHandler.resolve().isPresent() && (stacksHandler = (handler = (ICuriosItemHandler)lazyHandler.resolve().get()).getStacksHandler(identifier)).isPresent() && 0 < (stackHandler = ((ICurioStacksHandler)stacksHandler.get()).getCosmeticStacks()).getSlots() && !(itemStack = stackHandler.getStackInSlot(0)).m_41619_()) {
                    player.m_21008_(hand, itemStack);
                    stackHandler.setStackInSlot(0, ItemStack.f_41583_);
                    return Optional.of(InteractionResult.SUCCESS);
                }
            }
        }
        return Optional.empty();
    }

    private static String slotToUnequip(ArmorStand armorStand, Vec3 pos) {
        String shieldIdentifier;
        boolean isSmall = armorStand.m_31666_();
        Direction.Axis axis = armorStand.m_6350_().m_122434_();
        double x = isSmall ? pos.f_82479_ * 2.0 : pos.f_82479_;
        double z = isSmall ? pos.f_82481_ * 2.0 : pos.f_82481_;
        double front = axis == Direction.Axis.X ? z : x;
        double vertical = isSmall ? pos.f_82480_ * 2.0 : pos.f_82480_;
        String glovesIdentifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "hands" : "aether_gloves";
        String pendantIdentifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "necklace" : "aether_pendant";
        String capeIdentifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "back" : "aether_cape";
        String string = shieldIdentifier = (Boolean)AetherConfig.COMMON.use_curios_menu.get() != false ? "body" : "aether_shield";
        if (!EntityHooks.getItemByIdentifier(armorStand, glovesIdentifier).m_41619_()) {
            double d = Math.abs(front);
            double d2 = isSmall ? 0.15 : 0.2;
            if (d >= d2) {
                double d3 = isSmall ? 0.65 : 0.75;
                if (vertical >= d3 && vertical < 1.15) {
                    return glovesIdentifier;
                }
            }
        }
        if (!EntityHooks.getItemByIdentifier(armorStand, pendantIdentifier).m_41619_()) {
            double d = isSmall ? 1.2 : 1.3;
            if (vertical >= d) {
                double d4 = isSmall ? 0.8 : 0.6;
                if (vertical < 0.9 + d4) {
                    return pendantIdentifier;
                }
            }
        }
        if (!EntityHooks.getItemByIdentifier(armorStand, capeIdentifier).m_41619_()) {
            double d = isSmall ? 1.0 : 1.1;
            if (vertical >= d) {
                double d5 = isSmall ? 1.7 : 1.4;
                if (vertical < d5) {
                    return capeIdentifier;
                }
            }
        }
        if (!EntityHooks.getItemByIdentifier(armorStand, shieldIdentifier).m_41619_()) {
            double d = isSmall ? 0.9 : 1.0;
            if (vertical >= d) {
                double d6 = isSmall ? 1.5 : 1.2;
                if (vertical < d6) {
                    return shieldIdentifier;
                }
            }
        }
        return "";
    }

    private static ItemStack getItemByIdentifier(ArmorStand armorStand, String identifier) {
        IDynamicStackHandler stackHandler;
        ICuriosItemHandler handler;
        Optional stacksHandler;
        LazyOptional lazyHandler = CuriosApi.getCuriosInventory((LivingEntity)armorStand);
        if (lazyHandler.isPresent() && lazyHandler.resolve().isPresent() && (stacksHandler = (handler = (ICuriosItemHandler)lazyHandler.resolve().get()).getStacksHandler(identifier)).isPresent() && 0 < (stackHandler = ((ICurioStacksHandler)stacksHandler.get()).getCosmeticStacks()).getSlots()) {
            return stackHandler.getStackInSlot(0);
        }
        return ItemStack.f_41583_;
    }

    public static boolean preventEntityHooked(Entity projectileEntity, HitResult rayTraceResult) {
        if (rayTraceResult instanceof EntityHitResult) {
            EntityHitResult entityHitResult = (EntityHitResult)rayTraceResult;
            return entityHitResult.m_82443_().m_6095_().m_204039_(AetherTags.Entities.UNHOOKABLE) && projectileEntity instanceof FishingHook;
        }
        return false;
    }

    public static boolean preventSliderShieldBlock(DamageSource source) {
        return source.m_7639_() instanceof Slider;
    }

    public static boolean lightningHitKeys(Entity entity) {
        if (entity instanceof ItemEntity) {
            ItemEntity itemEntity = (ItemEntity)entity;
            return itemEntity.m_32055_().m_204117_(AetherTags.Items.DUNGEON_KEYS);
        }
        return false;
    }

    public static boolean thunderCrystalHitItems(Entity entity, LightningBolt lightning) {
        Optional lightningTrackerOptional;
        if (entity instanceof ItemEntity && (lightningTrackerOptional = LightningTracker.get(lightning).resolve()).isPresent()) {
            LightningTracker lightningTracker = (LightningTracker)lightningTrackerOptional.get();
            return lightningTracker.getOwner() instanceof ValkyrieQueen;
        }
        return false;
    }

    public static void trackDrops(LivingEntity entity, Collection<ItemEntity> itemDrops) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            itemDrops.forEach(itemEntity -> DroppedItem.get(itemEntity).ifPresent(droppedItem -> droppedItem.setOwner((Entity)player)));
        }
    }

    public static Collection<ItemEntity> handleEntityCurioDrops(LivingEntity entity, Collection<ItemEntity> itemDrops, boolean recentlyHit, int looting) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            MobAccessory.get(mob).ifPresent(accessoryMob -> {
                String[] allSlots;
                for (String identifier : allSlots = new String[]{"hands", "necklace", "aether_gloves", "aether_pendant"}) {
                    boolean flag;
                    List<ItemStack> itemStacks = itemDrops.stream().map(ItemEntity::m_32055_).filter(stack -> AetherMixinHooks.getIdentifierForItem((LivingEntity)accessoryMob.getMob(), stack).equals(identifier)).toList();
                    if (itemStacks.isEmpty()) continue;
                    ItemStack itemStack = itemStacks.get(0);
                    float f = accessoryMob.getEquipmentDropChance(identifier);
                    boolean bl = flag = f > 1.0f;
                    if (!itemStack.m_41619_()) {
                        itemDrops.removeIf(itemEntity -> ItemStack.m_150942_((ItemStack)itemEntity.m_32055_(), (ItemStack)itemStack));
                    }
                    if (itemStack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)itemStack) || !recentlyHit || !(Math.max(mob.m_217043_().m_188501_() - (float)looting * 0.01f, 0.0f) < f)) continue;
                    if (!flag && itemStack.m_41763_()) {
                        itemStack.m_41721_(itemStack.m_41776_() - accessoryMob.getMob().m_217043_().m_188503_(1 + accessoryMob.getMob().m_217043_().m_188503_(Math.max(itemStack.m_41776_() - 3, 1))));
                    }
                    ItemEntity itemEntity2 = new ItemEntity(accessoryMob.getMob().m_9236_(), accessoryMob.getMob().m_20185_(), accessoryMob.getMob().m_20186_(), accessoryMob.getMob().m_20189_(), itemStack);
                    itemEntity2.m_32060_();
                    itemDrops.add(itemEntity2);
                }
            });
        }
        return itemDrops;
    }

    public static int modifyExperience(LivingEntity entity, int experience) {
        Mob mob;
        LazyOptional<MobAccessory> accessoryMobLazy;
        if (entity instanceof Mob && (accessoryMobLazy = MobAccessory.get(mob = (Mob)entity)).isPresent() && accessoryMobLazy.resolve().isPresent()) {
            MobAccessory accessoryMob = (MobAccessory)accessoryMobLazy.resolve().get();
            LazyOptional lazyHandler = CuriosApi.getCuriosInventory((LivingEntity)mob);
            if (lazyHandler.isPresent() && lazyHandler.resolve().isPresent()) {
                ICuriosItemHandler handler = (ICuriosItemHandler)lazyHandler.resolve().get();
                if (experience > 0) {
                    String[] allSlots;
                    for (String identifier : allSlots = new String[]{"hands", "necklace", "aether_gloves", "aether_pendant"}) {
                        ItemStack stack;
                        Optional optionalSlotResult = handler.findCurio(identifier, 0);
                        if (!optionalSlotResult.isPresent() || (stack = ((SlotResult)optionalSlotResult.get()).stack()).m_41619_() || !(accessoryMob.getEquipmentDropChance(identifier) <= 1.0f)) continue;
                        experience += 1 + mob.m_217043_().m_188503_(3);
                    }
                }
            }
        }
        return experience;
    }

    public static boolean preventInebriation(LivingEntity livingEntity, MobEffectInstance appliedInstance) {
        return livingEntity.m_21023_((MobEffect)AetherEffects.REMEDY.get()) && appliedInstance.m_19544_() == AetherEffects.INEBRIATION.get();
    }
}

