/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import slimeknights.mantle.data.MantleCodecs;
import slimeknights.mantle.loot.AbstractLootModifierBuilder;
import slimeknights.mantle.loot.condition.ILootModifierCondition;

public class AddEntryLootModifier
extends LootModifier {
    public static final Codec<AddEntryLootModifier> CODEC = RecordCodecBuilder.create(inst -> AddEntryLootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)ILootModifierCondition.CODEC.listOf().fieldOf("post_conditions").forGetter(m -> m.modifierConditions), (App)MantleCodecs.LOOT_ENTRY.fieldOf("entry").forGetter(m -> m.entry), (App)MantleCodecs.LOOT_FUNCTIONS.fieldOf("functions").forGetter(m -> m.functions))).apply((Applicative)inst, AddEntryLootModifier::new));
    private final List<ILootModifierCondition> modifierConditions;
    private final LootPoolEntryContainer entry;
    private final LootItemFunction[] functions;
    private final BiFunction<ItemStack, LootContext, ItemStack> combinedFunctions;

    protected AddEntryLootModifier(LootItemCondition[] conditionsIn, List<ILootModifierCondition> modifierConditions, LootPoolEntryContainer entry, LootItemFunction[] functions) {
        super(conditionsIn);
        this.modifierConditions = modifierConditions;
        this.entry = entry;
        this.functions = functions;
        this.combinedFunctions = LootItemFunctions.m_80770_((BiFunction[])functions);
    }

    public static Builder builder(LootPoolEntryContainer entry) {
        return new Builder(entry);
    }

    public static Builder builder(LootPoolEntryContainer.Builder<?> builder) {
        return AddEntryLootModifier.builder(builder.m_7512_());
    }

    @Nonnull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (ILootModifierCondition modifierCondition : this.modifierConditions) {
            if (modifierCondition.test((List<ItemStack>)generatedLoot, context)) continue;
            return generatedLoot;
        }
        Consumer consumer = LootItemFunction.m_80724_(this.combinedFunctions, arg_0 -> generatedLoot.add(arg_0), (LootContext)context);
        this.entry.m_6562_(context, generator -> generator.m_6941_(consumer, context));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public static class Builder
    extends AbstractLootModifierBuilder<Builder> {
        private final List<ILootModifierCondition> modifierConditions = new ArrayList<ILootModifierCondition>();
        private final LootPoolEntryContainer entry;
        private final List<LootItemFunction> functions = new ArrayList<LootItemFunction>();

        public Builder addCondition(ILootModifierCondition condition) {
            this.modifierConditions.add(condition);
            return this;
        }

        public Builder addFunction(LootItemFunction function) {
            this.functions.add(function);
            return this;
        }

        public AddEntryLootModifier build() {
            return new AddEntryLootModifier(this.getConditions(), this.modifierConditions, this.entry, this.functions.toArray(new LootItemFunction[0]));
        }

        private Builder(LootPoolEntryContainer entry) {
            this.entry = entry;
        }
    }
}

