/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.predicate.item;

import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.data.loadable.record.SingletonLoader;
import slimeknights.mantle.data.predicate.IJsonPredicate;
import slimeknights.mantle.data.predicate.RegistryPredicateRegistry;
import slimeknights.mantle.util.RegistryHelper;

public interface ItemPredicate
extends IJsonPredicate<Item> {
    public static final ItemPredicate ANY = ItemPredicate.simple(item -> true);
    public static final RegistryPredicateRegistry<Item, Item> LOADER = new RegistryPredicateRegistry<Item, Item>("Item Predicate", ANY, Loadables.ITEM, Function.identity(), "items", Loadables.ITEM_TAG, RegistryHelper::contains);

    @Override
    default public IJsonPredicate<Item> inverted() {
        return LOADER.invert(this);
    }

    public static ItemPredicate simple(final Predicate<Item> predicate) {
        return SingletonLoader.singleton(loader -> new ItemPredicate(){
            final /* synthetic */ RecordLoadable val$loader;
            {
                this.val$loader = recordLoadable;
            }

            @Override
            public boolean matches(Item item) {
                return predicate.test(item);
            }

            @Override
            public RecordLoadable<? extends ItemPredicate> getLoader() {
                return this.val$loader;
            }
        });
    }

    public static IJsonPredicate<Item> set(Item ... items) {
        return LOADER.setOf((Item[])items);
    }

    public static IJsonPredicate<Item> tag(TagKey<Item> tag) {
        return LOADER.tag(tag);
    }

    @SafeVarargs
    public static IJsonPredicate<Item> and(IJsonPredicate<Item> ... predicates) {
        return LOADER.and(List.of(predicates));
    }

    @SafeVarargs
    public static IJsonPredicate<Item> or(IJsonPredicate<Item> ... predicates) {
        return LOADER.or(List.of(predicates));
    }
}

