/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.mantle.util.JsonHelper;
import slimeknights.mantle.util.typed.TypedMap;

public enum NBTLoadable implements RecordLoadable<CompoundTag>
{
    DISALLOW_STRING,
    ALLOW_STRING;


    @Override
    public CompoundTag deserialize(JsonObject json, TypedMap context) {
        return (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, (JsonElement)json);
    }

    @Override
    public CompoundTag convert(JsonElement element, String key, TypedMap context) {
        if (this == ALLOW_STRING && !element.isJsonObject()) {
            try {
                return TagParser.m_129359_((String)JsonHelper.DEFAULT_GSON.toJson(element));
            }
            catch (CommandSyntaxException e) {
                throw new JsonSyntaxException("Invalid NBT Entry: ", (Throwable)e);
            }
        }
        return (CompoundTag)RecordLoadable.super.convert(element, key, context);
    }

    public JsonObject serialize(CompoundTag object) {
        return ((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)object)).getAsJsonObject();
    }

    @Override
    public void serialize(CompoundTag object, JsonObject json) {
        json.entrySet().addAll(this.serialize(object).entrySet());
    }

    @Override
    public CompoundTag decode(FriendlyByteBuf buffer, TypedMap context) {
        CompoundTag tag = buffer.m_130260_();
        if (tag == null) {
            return new CompoundTag();
        }
        return tag;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, CompoundTag object) {
        buffer.m_130079_(object);
    }

    @Override
    public <P> LoadableField<CompoundTag, P> nullableField(String key, Function<P, CompoundTag> getter) {
        return new NullableNBTField<P>(this, key, getter);
    }

    private record NullableNBTField<P>(Loadable<CompoundTag> loadable, String key, Function<P, CompoundTag> getter) implements LoadableField<CompoundTag, P>
    {
        @Override
        @Nullable
        public CompoundTag get(JsonObject json, String key, TypedMap context) {
            return this.loadable.getOrDefault(json, key, null, context);
        }

        @Override
        public void serialize(P parent, JsonObject json) {
            CompoundTag nbt = this.getter.apply(parent);
            if (nbt != null) {
                json.add(this.key, this.loadable.serialize(nbt));
            }
        }

        @Override
        @Nullable
        public CompoundTag decode(FriendlyByteBuf buffer, TypedMap context) {
            return buffer.m_130260_();
        }

        @Override
        public void encode(FriendlyByteBuf buffer, P parent) {
            buffer.m_130079_(this.getter.apply(parent));
        }
    }
}

