/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.common;

import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import slimeknights.mantle.data.loadable.ErrorFactory;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.NBTLoadable;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.data.loadable.primitive.IntLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public class FluidStackLoadable {
    private static final Function<FluidStack, Fluid> FLUID_GETTER = FluidStack::getFluid;
    private static final Predicate<FluidStack> COMPACT_NBT = stack -> !stack.hasTag();
    private static final BiFunction<FluidStack, ErrorFactory, FluidStack> NOT_EMPTY = (stack, error) -> {
        if (stack.isEmpty()) {
            throw error.create("FluidStack cannot be empty");
        }
        return stack;
    };
    private static final LoadableField<Fluid, FluidStack> FLUID = Loadables.FLUID.defaultField("fluid", Fluids.f_76191_, false, FLUID_GETTER);
    private static final LoadableField<Integer, FluidStack> AMOUNT = IntLoadable.FROM_ZERO.requiredField("amount", FluidStack::getAmount);
    private static final LoadableField<CompoundTag, FluidStack> NBT = NBTLoadable.ALLOW_STRING.nullableField("nbt", FluidStack::getTag);
    public static final Loadable<FluidStack> OPTIONAL_BUCKET = FluidStackLoadable.fixedSize(1000);
    public static final RecordLoadable<FluidStack> OPTIONAL_STACK = RecordLoadable.create(FLUID, AMOUNT, (fluid, count) -> FluidStackLoadable.makeStack(fluid, count, null));
    public static final RecordLoadable<FluidStack> OPTIONAL_BUCKET_NBT = FluidStackLoadable.fixedSizeNBT(1000);
    public static final RecordLoadable<FluidStack> OPTIONAL_STACK_NBT = RecordLoadable.create(FLUID, AMOUNT, NBT, FluidStackLoadable::makeStack);
    public static final Loadable<FluidStack> REQUIRED_BUCKET = FluidStackLoadable.notEmpty(OPTIONAL_BUCKET);
    public static final RecordLoadable<FluidStack> REQUIRED_STACK = FluidStackLoadable.notEmpty(OPTIONAL_STACK);
    public static final RecordLoadable<FluidStack> REQUIRED_BUCKET_NBT = FluidStackLoadable.notEmpty(OPTIONAL_BUCKET_NBT);
    public static final RecordLoadable<FluidStack> REQUIRED_STACK_NBT = FluidStackLoadable.notEmpty(OPTIONAL_STACK_NBT);

    private FluidStackLoadable() {
    }

    private static FluidStack makeStack(Fluid fluid, int amount, @Nullable CompoundTag nbt) {
        if (fluid == Fluids.f_76191_ || amount <= 0) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(fluid, amount, nbt);
    }

    public static Loadable<FluidStack> fixedSize(int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Count must be positive, received " + amount);
        }
        return Loadables.FLUID.flatXmap(fluid -> FluidStackLoadable.makeStack(fluid, amount, null), FLUID_GETTER);
    }

    public static RecordLoadable<FluidStack> fixedSizeNBT(int amount) {
        if (amount <= 0) {
            throw new IllegalArgumentException("Amount must be positive, received " + amount);
        }
        return RecordLoadable.create(FLUID, NBT, (fluid, tag) -> FluidStackLoadable.makeStack(fluid, amount, tag)).compact(OPTIONAL_BUCKET, COMPACT_NBT);
    }

    public static Loadable<FluidStack> notEmpty(Loadable<FluidStack> loadable) {
        return loadable.validate(NOT_EMPTY);
    }

    public static RecordLoadable<FluidStack> notEmpty(RecordLoadable<FluidStack> loadable) {
        return loadable.validate((BiFunction)NOT_EMPTY);
    }
}

