/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.array;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import java.util.Arrays;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.array.ArrayLoadable;
import slimeknights.mantle.data.loadable.field.DefaultingField;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record ObjectArrayLoadable<T>(Loadable<T> base, IntFunction<T[]> constructor, int minSize, int maxSize, boolean allowNull) implements ArrayLoadable.SizeRange<T[]>
{
    @Override
    public int getLength(T[] array) {
        return array.length;
    }

    @Nullable
    private T parseElement(JsonElement element, String key, TypedMap context) {
        if (this.allowNull && element.isJsonNull()) {
            return null;
        }
        return this.base.convert(element, key, context);
    }

    @Override
    public T[] convertCompact(JsonElement element, String key, TypedMap context) {
        T[] result = this.constructor.apply(1);
        result[0] = this.parseElement(element, key, context);
        return result;
    }

    @Override
    public T[] convertArray(JsonArray array, String key, TypedMap context) {
        T[] result = this.constructor.apply(array.size());
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.parseElement(array.get(i), key + "[" + i + "]", context);
        }
        return result;
    }

    private JsonElement serializeElement(@Nullable T object, int index) {
        if (object == null) {
            if (this.allowNull) {
                return JsonNull.INSTANCE;
            }
            throw new NullPointerException("Received null at index " + index + " in ArrayLoadable not supporting null");
        }
        return this.base.serialize(object);
    }

    @Override
    public JsonElement serializeFirst(T[] object) {
        return this.serializeElement(object[0], 0);
    }

    @Override
    public void serializeAll(JsonArray array, T[] object) {
        for (int i = 0; i < object.length; ++i) {
            array.add(this.serializeElement(object[i], i));
        }
    }

    @Override
    public T[] decode(FriendlyByteBuf buffer, TypedMap context) {
        int max = buffer.m_130242_();
        T[] array = this.constructor.apply(max);
        for (int i = 0; i < max; ++i) {
            array[i] = this.allowNull && !buffer.readBoolean() ? null : this.base.decode(buffer, context);
        }
        return array;
    }

    @Override
    public void encode(FriendlyByteBuf buffer, T[] array) {
        buffer.m_130130_(array.length);
        for (T element : array) {
            if (this.allowNull) {
                buffer.writeBoolean(element != null);
            } else {
                Objects.requireNonNull(element);
            }
            if (element == null) continue;
            this.base.encode(buffer, element);
        }
    }

    @Override
    public <P> LoadableField<T[], P> defaultField(String key, T[] defaultValue, boolean serializeDefault, Function<P, T[]> getter) {
        return new DefaultingField<T[], P>(this, key, defaultValue, serializeDefault ? null : Arrays::equals, getter);
    }

    @Override
    public <P> LoadableField<T[], P> emptyField(String key, boolean serializeEmpty, Function<P, T[]> getter) {
        return this.defaultField(key, this.constructor.apply(0), serializeEmpty, getter);
    }
}

