/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.common.item.IAugmentItem;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public final class AugmentDataHelper {
    private AugmentDataHelper() {
    }

    public static boolean isAugmentItem(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof IAugmentItem;
    }

    public static boolean hasAugmentData(ItemStack stack) {
        return AugmentDataHelper.getAugmentData(stack) != null;
    }

    @Nullable
    public static CompoundTag getAugmentData(ItemStack augment) {
        CompoundTag augmentData = augment.m_41737_("AugmentData");
        if (augmentData == null && AugmentDataHelper.isAugmentItem(augment)) {
            return ((IAugmentItem)augment.m_41720_()).getAugmentData(augment);
        }
        return augmentData;
    }

    public static String getAugmentType(ItemStack augment) {
        CompoundTag augmentTag = AugmentDataHelper.getAugmentData(augment);
        return augmentTag != null ? augmentTag.m_128461_("Type") : "";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        CompoundTag augmentData = new CompoundTag();

        public CompoundTag build() {
            return this.augmentData.m_128456_() ? null : this.augmentData;
        }

        public Builder type(String type) {
            this.augmentData.m_128359_("Type", type);
            return this;
        }

        public Builder mod(String mod, float value) {
            this.augmentData.m_128350_(mod, value);
            return this;
        }

        public Builder feature(String mod, String value) {
            this.augmentData.m_128359_(mod, value);
            return this;
        }
    }
}

