/*
 * Decompiled with CFR 0.152.
 */
package net.ribs.vintagedelight.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.ribs.vintagedelight.item.ModItems;

public class CheeseMoldBlock
extends Block
implements WorldlyContainerHolder,
SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)5);
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    private static final int PROCESSING_TIME_TICKS = 8400;

    public CheeseMoldBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60977_());
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        int level = (Integer)state.m_61143_((Property)LEVEL);
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_41720_() == ModItems.CHEESE_CURDS.get() && level < 4) {
            BlockState newState = (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(level + 1));
            world.m_5594_(null, pos, SoundEvents.f_12195_, SoundSource.BLOCKS, 1.0f, 1.0f);
            world.m_7731_(pos, newState, 3);
            if (level == 3) {
                world.m_186460_(pos, (Block)this, 8400);
            }
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            player.m_6674_(hand);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (itemStack.m_41720_() == ModItems.CHEESE_WHEEL.get() && level == 0) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(5)), 3);
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            player.m_6674_(hand);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        if (level == 5 && player.m_21120_(hand).m_41619_()) {
            if (!world.f_46443_) {
                ItemStack cheeseItem = new ItemStack((ItemLike)ModItems.CHEESE_WHEEL.get());
                ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + 0.5, cheeseItem);
                itemEntity.m_32060_();
                world.m_7967_((Entity)itemEntity);
                world.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 1.0f, 1.0f);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)), 3);
            }
            player.m_6674_(hand);
            return InteractionResult.m_19078_((boolean)world.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        super.m_213897_(state, world, pos, random);
        int level = (Integer)state.m_61143_((Property)LEVEL);
        if (level == 4) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(5)), 3);
        }
    }

    public WorldlyContainer m_5840_(BlockState state, LevelAccessor world, BlockPos pos) {
        int level = (Integer)state.m_61143_((Property)LEVEL);
        if (level < 4) {
            return new InputContainer(state, world, pos);
        }
        return new OutputContainer(state, world, pos, new ItemStack((ItemLike)ModItems.CHEESE_WHEEL.get()));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LEVEL, FACING, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    static class InputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;

        public InputContainer(BlockState state, LevelAccessor level, BlockPos pos) {
            super(1);
            this.state = state;
            this.level = level;
            this.pos = pos;
        }

        public int[] m_7071_(Direction side) {
            int[] nArray;
            if (side == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int index, ItemStack stack, Direction direction) {
            return direction == Direction.UP && stack.m_41720_() == ModItems.CHEESE_CURDS.get();
        }

        public boolean m_7157_(int index, ItemStack stack, Direction direction) {
            return false;
        }

        public void m_6596_() {
            int currentLevel;
            ItemStack itemStack = this.m_8020_(0);
            if (!itemStack.m_41619_() && itemStack.m_41720_() == ModItems.CHEESE_CURDS.get() && (currentLevel = ((Integer)this.state.m_61143_((Property)LEVEL)).intValue()) < 4) {
                BlockState newState = (BlockState)this.state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(currentLevel + 1));
                this.level.m_7731_(this.pos, newState, 3);
                this.m_8016_(0);
                if (currentLevel == 3 && this.level instanceof ServerLevel) {
                    this.level.m_186460_(this.pos, newState.m_60734_(), 8400);
                }
            }
        }
    }

    static class OutputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private final ItemStack output;

        public OutputContainer(BlockState state, LevelAccessor level, BlockPos pos, ItemStack output) {
            super(new ItemStack[]{output});
            this.state = state;
            this.level = level;
            this.pos = pos;
            this.output = output;
        }

        public int[] m_7071_(Direction side) {
            int[] nArray;
            if (side == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int index, ItemStack stack, Direction direction) {
            return false;
        }

        public boolean m_7157_(int index, ItemStack stack, Direction direction) {
            return direction == Direction.DOWN && (Integer)this.state.m_61143_((Property)LEVEL) == 5 && this.output.m_41720_() == ModItems.CHEESE_WHEEL.get();
        }

        public void m_6596_() {
            if (this.output.m_41619_()) {
                this.level.m_7731_(this.pos, (BlockState)this.state.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)), 3);
            }
        }
    }
}

