/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.grid.fluid;

import cofh.core.util.helpers.FluidHelper;
import cofh.lib.util.TimeTracker;
import cofh.thermal.dynamics.api.grid.IGridType;
import cofh.thermal.dynamics.api.helper.GridHelper;
import cofh.thermal.dynamics.grid.Grid;
import cofh.thermal.dynamics.grid.fluid.FluidGridNode;
import cofh.thermal.dynamics.grid.fluid.GridFluidStorage;
import cofh.thermal.dynamics.init.registries.TDynGrids;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidGrid
extends Grid<FluidGrid, FluidGridNode>
implements IFluidHandler {
    protected static final int NODE_CAPACITY = 100;
    protected final GridFluidStorage storage = new GridFluidStorage(100);
    protected LazyOptional<?> fluidCap = LazyOptional.empty();
    protected FluidStack renderFluid = FluidStack.EMPTY;
    protected FluidStack prevRenderFluid = FluidStack.EMPTY;
    protected TimeTracker timeTracker = new TimeTracker();
    protected boolean wasFilled;
    protected boolean needsUpdate;
    protected FluidGridNode[] distArray = new FluidGridNode[0];
    protected int distIndex = 0;

    public FluidGrid(UUID id, Level world) {
        super((IGridType)TDynGrids.FLUID_GRID.get(), id, world);
    }

    @Override
    public FluidGridNode newNode() {
        return new FluidGridNode(this);
    }

    @Override
    public void tick() {
        int i;
        this.storage.tick();
        if (this.distArray.length != this.getNodes().size()) {
            this.distArray = this.getNodes().values().toArray(new FluidGridNode[0]);
        }
        int curIndex = this.distIndex;
        if (this.distIndex >= this.distArray.length) {
            this.distIndex = 0;
        }
        for (i = this.distIndex; i < this.distArray.length; ++i) {
            this.rrPreNodeTick(i);
        }
        for (i = 0; i < this.distIndex; ++i) {
            this.rrPreNodeTick(i);
        }
        this.renderUpdate();
        for (i = this.distIndex; i < this.distArray.length; ++i) {
            if (!this.rrNodeTick(curIndex, i)) continue;
            this.storage.postTick();
            return;
        }
        for (i = 0; i < this.distIndex; ++i) {
            if (!this.rrNodeTick(curIndex, i)) continue;
            this.storage.postTick();
            return;
        }
        ++this.distIndex;
        this.storage.postTick();
    }

    private void rrPreNodeTick(int i) {
        if (this.distArray[i].isLoaded()) {
            this.distArray[i].attachmentTick();
        }
    }

    private boolean rrNodeTick(int curIndex, int i) {
        if (!this.distArray[i].isLoaded()) {
            return false;
        }
        this.distArray[i].distributionTick();
        if (this.getFluid().isEmpty()) {
            this.distIndex = i + 1;
            if (curIndex == this.distIndex) {
                --this.distIndex;
            }
            return true;
        }
        return false;
    }

    private void renderUpdate() {
        this.prevRenderFluid = this.renderFluid;
        this.renderFluid = new FluidStack(this.getFluid(), 1000);
        if (!FluidHelper.fluidsEqual((FluidStack)this.prevRenderFluid, (FluidStack)this.renderFluid) || this.wasFilled && this.timeTracker.hasDelayPassed(this.world, 40) || this.needsUpdate) {
            if (!this.wasFilled && this.renderFluid.isEmpty()) {
                this.timeTracker.markTime(this.world);
                this.wasFilled = true;
                return;
            }
            this.updateHosts();
            this.wasFilled = false;
            this.needsUpdate = false;
        }
    }

    @Override
    public void onModified() {
        this.distArray = new FluidGridNode[0];
        this.storage.setBaseCapacity(Math.max(8000, this.getNodes().size() * 100));
        super.onModified();
    }

    @Override
    public void onMerge(FluidGrid from) {
        this.storage.setBaseCapacity(Math.max(8000, this.getNodes().size() * 100));
        this.storage.setCapacity(this.getCapacity() + from.getCapacity());
        this.storage.setFluid(new FluidStack(this.storage.getFluid(), this.getFluidAmount() + from.getFluidAmount()));
        this.needsUpdate = true;
        this.refreshCapabilities();
        from.refreshCapabilities();
    }

    @Override
    public void onSplit(List<FluidGrid> others) {
        int totalNodes = 0;
        for (FluidGrid grid : others) {
            int gridNodes = grid.getNodes().size();
            totalNodes += grid.getNodes().size();
            grid.setBaseCapacity(Math.max(8000, gridNodes * 100));
            grid.setCapacity(this.getCapacity());
            if (!this.renderFluid.isEmpty()) {
                grid.needsUpdate = true;
            }
            grid.refreshCapabilities();
        }
        this.refreshCapabilities();
        if (this.getFluid().isEmpty()) {
            return;
        }
        int fluidPerNode = this.getFluid().getAmount() / totalNodes;
        int remFluid = this.getFluid().getAmount() % totalNodes;
        for (FluidGrid grid : others) {
            int gridNodes = grid.getNodes().size();
            grid.setFluid(new FluidStack(this.getFluid(), fluidPerNode * gridNodes));
        }
        others.get(0).setFluid(new FluidStack(this.getFluid(), others.get(0).getFluid().getAmount() + remFluid));
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        this.storage.write(tag);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.storage.deserializeNBT(nbt);
    }

    @Override
    public boolean canConnectOnSide(BlockEntity tile, @Nullable Direction dir) {
        if (GridHelper.getGridHost(tile) != null) {
            return false;
        }
        if (dir != null) {
            return tile.getCapability(ForgeCapabilities.FLUID_HANDLER, dir).isPresent();
        }
        return false;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            if (!this.fluidCap.isPresent()) {
                this.fluidCap = LazyOptional.of(() -> this.storage);
            }
            return this.fluidCap.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    public void refreshCapabilities() {
        this.fluidCap.invalidate();
    }

    public int getCapacity() {
        return this.storage.getCapacity();
    }

    public FluidStack getFluid() {
        return this.storage.getFluid();
    }

    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    public int getFluidAmount() {
        return this.storage.getFluid().getAmount();
    }

    public void setBaseCapacity(int baseCapacity) {
        this.storage.setBaseCapacity(baseCapacity);
    }

    public void setCapacity(int capacity) {
        this.storage.setCapacity(capacity);
    }

    public void setFluid(FluidStack fluid) {
        this.storage.setFluid(fluid);
    }

    public int getTanks() {
        return this.storage.getTanks();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.storage.getFluidInTank(tank);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.storage.fill(resource, action);
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.storage.drain(resource, action);
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.storage.drain(maxDrain, action);
    }

    public int getTankCapacity(int tank) {
        return this.storage.getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
        return this.storage.isFluidValid(tank, stack);
    }
}

