/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.innovation.common.item;

import cofh.core.common.item.IMultiModeItem;
import cofh.core.util.ProxyUtils;
import cofh.core.util.filter.EmptyFilter;
import cofh.core.util.filter.FilterRegistry;
import cofh.core.util.filter.IFilter;
import cofh.core.util.filter.IFilterableItem;
import cofh.core.util.helpers.AugmentableHelper;
import cofh.core.util.helpers.FilterHelper;
import cofh.lib.api.item.IColorableItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.raytracer.RayTracer;
import cofh.thermal.core.common.config.ThermalCoreConfig;
import cofh.thermal.core.init.registries.TCoreSounds;
import cofh.thermal.lib.common.item.EnergyContainerItemAugmentable;
import cofh.thermal.lib.common.item.IFlexibleEnergyContainerItem;
import cofh.thermal.lib.util.ThermalAugmentRules;
import java.util.List;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class RFMagnetItem
extends EnergyContainerItemAugmentable
implements IColorableItem,
DyeableLeatherItem,
IFilterableItem,
IMultiModeItem,
IFlexibleEnergyContainerItem,
Vanishable {
    protected static final int MAP_CAPACITY = 128;
    protected static final WeakHashMap<ItemStack, IFilter> FILTERS = new WeakHashMap(128);
    protected static final int RADIUS = 4;
    protected static final int REACH = 64;
    protected static final int MIN_AGE = 20;
    protected int energyPerItem = 25;
    protected int energyPerUse = 200;
    protected boolean obeyPickupDelay = true;

    public RFMagnetItem(Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("color"), (stack, world, entity, seed) -> this.m_41113_(stack) ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("state"), (stack, world, entity, seed) -> (this.getEnergyStored(stack) > 0 ? 0.5f : 0.0f) + (this.getMode(stack) > 0 ? 0.25f : 0.0f));
        ProxyUtils.registerColorable((Item)this);
        this.numSlots = () -> ThermalCoreConfig.toolAugments;
        this.augValidator = ThermalAugmentRules.createAllowValidator((String[])new String[]{"Upgrade", "RF", "Area", "Filter"});
    }

    public void setEnergyPerUse(int energyPerUse) {
        this.energyPerUse = energyPerUse;
    }

    public void setEnergyPerItem(int energyPerItem) {
        this.energyPerItem = energyPerItem;
    }

    public void setObeyItemPickupDelay(boolean obeyPickupDelay) {
        this.obeyPickupDelay = obeyPickupDelay;
    }

    protected void tooltipDelegate(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.magnet.use").m_130940_(ChatFormatting.GRAY));
        if (FilterHelper.hasFilter((ItemStack)stack)) {
            tooltip.add((Component)StringHelper.getTextComponent((String)"info.thermal.magnet.use.sneak").m_130940_(ChatFormatting.DARK_GRAY));
        }
        tooltip.add((Component)StringHelper.getTextComponent((String)("info.thermal.magnet.mode." + this.getMode(stack))).m_130940_(ChatFormatting.ITALIC));
        this.addModeChangeTooltip(this, stack, worldIn, tooltip, flagIn);
        super.tooltipDelegate(stack, worldIn, tooltip, flagIn);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        return this.useDelegate(stack, playerIn, handIn) ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19098_((Object)stack);
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return this.useDelegate(stack, context.m_43723_(), context.m_43724_()) ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!Utils.timeCheckQuarter()) {
            return;
        }
        if (Utils.isClientWorld((Level)worldIn) || Utils.isFakePlayer((Entity)entityIn) || this.getMode(stack) <= 0) {
            return;
        }
        Player player = (Player)entityIn;
        if (this.getEnergyStored(stack) < this.energyPerItem && !player.f_36077_.f_35937_) {
            return;
        }
        int radius = this.getRadius(stack);
        int radSq = radius * radius;
        AABB area = new AABB(player.m_20183_().m_7918_(-radius, -radius, -radius), player.m_20183_().m_7918_(1 + radius, 1 + radius, 1 + radius));
        List items = worldIn.m_6443_(ItemEntity.class, area, EntitySelector.f_20402_);
        if (Utils.isClientWorld((Level)worldIn)) {
            for (ItemEntity item : items) {
                if (this.obeyPickupDelay && item.m_32063_() || item.getPersistentData().m_128471_("PreventRemoteMovement") || !(item.m_20182_().m_82557_(player.m_20182_()) <= (double)radSq)) continue;
                worldIn.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, item.m_20185_(), item.m_20186_(), item.m_20189_(), 0.0, 0.0, 0.0);
            }
        } else {
            Predicate filterRules = this.getFilter(stack).getItemRules();
            int itemCount = 0;
            for (ItemEntity item : items) {
                if (this.obeyPickupDelay && item.m_32063_() || item.getPersistentData().m_128471_("PreventRemoteMovement") || !filterRules.test(item.m_32055_()) || item.m_19749_() != null && this.obeyPickupDelay && item.m_32059_() < 20 || !(item.m_20182_().m_82557_(player.m_20182_()) <= (double)radSq)) continue;
                item.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                item.m_32010_(0);
                ++itemCount;
            }
            if (!player.f_36077_.f_35937_) {
                this.extractEnergy(stack, this.energyPerItem * itemCount, false);
            }
        }
    }

    protected boolean useDelegate(ItemStack stack, Player player, InteractionHand hand) {
        if (Utils.isFakePlayer((Entity)player)) {
            return false;
        }
        if (player.m_36341_() && hand == InteractionHand.MAIN_HAND) {
            return player instanceof ServerPlayer && this.openFilterGui((ServerPlayer)player, stack);
        }
        if (this.getEnergyStored(stack) >= this.energyPerUse || player.f_36077_.f_35937_) {
            BlockHitResult traceResult = RayTracer.retrace((Player)player, (double)64.0);
            if (traceResult.m_6662_() != HitResult.Type.BLOCK) {
                return false;
            }
            int radius = this.getRadius(stack);
            int radSq = radius * radius;
            Level world = player.m_20193_();
            BlockPos pos = traceResult.m_82425_();
            AABB area = new AABB(pos.m_7918_(-radius, -radius, -radius), pos.m_7918_(1 + radius, 1 + radius, 1 + radius));
            List items = world.m_6443_(ItemEntity.class, area, EntitySelector.f_20402_);
            if (Utils.isClientWorld((Level)world)) {
                for (ItemEntity item : items) {
                    if (!(item.m_20182_().m_82557_(traceResult.m_82450_()) <= (double)radSq)) continue;
                    world.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, item.m_20185_(), item.m_20186_(), item.m_20189_(), 0.0, 0.0, 0.0);
                }
            } else {
                Predicate filterRules = this.getFilter(stack).getItemRules();
                int itemCount = 0;
                for (ItemEntity item : items) {
                    if (this.obeyPickupDelay && item.m_32063_() || item.getPersistentData().m_128471_("PreventRemoteMovement") || !filterRules.test(item.m_32055_()) || !(item.m_20182_().m_82557_(traceResult.m_82450_()) <= (double)radSq)) continue;
                    item.m_6034_(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    item.m_32010_(0);
                    ++itemCount;
                }
                if (!player.f_36077_.f_35937_ && itemCount > 0) {
                    this.extractEnergy(stack, this.energyPerUse + this.energyPerItem * itemCount, false);
                }
            }
            player.m_6674_(hand);
            stack.m_41754_(5);
            player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)TCoreSounds.SOUND_MAGNET.get(), SoundSource.PLAYERS, 0.4f, 1.0f);
        }
        return true;
    }

    protected int getRadius(ItemStack stack) {
        float base = AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"BaseMod", (float)1.0f);
        float mod = AugmentableHelper.getPropertyWithDefault((ItemStack)stack, (String)"Radius", (float)1.0f);
        return Math.round(4.0f + mod * base);
    }

    protected void setAttributesFromAugment(ItemStack container, CompoundTag augmentData) {
        CompoundTag subTag = container.m_41737_("Properties");
        if (subTag == null) {
            return;
        }
        AugmentableHelper.setAttributeFromAugmentAdd((CompoundTag)subTag, (CompoundTag)augmentData, (String)"Radius");
        AugmentableHelper.setAttributeFromAugmentString((CompoundTag)subTag, (CompoundTag)augmentData, (String)"FilterType");
        super.setAttributesFromAugment(container, augmentData);
    }

    public void updateAugmentState(ItemStack container, List<ItemStack> augments) {
        super.updateAugmentState(container, augments);
        if (!FilterHelper.hasFilter((ItemStack)container)) {
            container.m_41784_().m_128473_("Filter");
        }
        FILTERS.remove(container);
    }

    public IFilter getFilter(ItemStack stack) {
        String filterType = FilterHelper.getFilterType((ItemStack)stack);
        if (filterType.isEmpty()) {
            return EmptyFilter.INSTANCE;
        }
        IFilter ret = FILTERS.get(stack);
        if (ret != null) {
            return ret;
        }
        if (FILTERS.size() > 128) {
            FILTERS.clear();
        }
        FILTERS.put(stack, FilterRegistry.getFilter((String)filterType, (CompoundTag)stack.m_41783_()));
        return FILTERS.get(stack);
    }

    public void onFilterChanged(ItemStack stack) {
        FILTERS.remove(stack);
    }

    public void onModeChange(Player player, ItemStack stack) {
        player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)TCoreSounds.SOUND_MAGNET.get(), SoundSource.PLAYERS, 0.4f, 0.8f + 0.4f * (float)this.getMode(stack));
        ProxyUtils.setOverlayMessage((Player)player, (Component)Component.m_237115_((String)("info.thermal.magnet.mode." + this.getMode(stack))));
    }
}

