/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.api.items.IAdvancedPotionItem;
import com.aizistral.enigmaticlegacy.entities.EnigmaticPotionEntity;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemNBTHelper;
import com.aizistral.enigmaticlegacy.helpers.PotionHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBase;
import com.aizistral.enigmaticlegacy.objects.AdvancedPotion;
import com.aizistral.enigmaticlegacy.registries.EnigmaticPotions;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class UltimatePotionSplash
extends ItemBase
implements IAdvancedPotionItem {
    public IAdvancedPotionItem.PotionType potionType;

    public UltimatePotionSplash(Rarity rarity, IAdvancedPotionItem.PotionType type) {
        super(ItemBase.getDefaultProperties().m_41497_(rarity).m_41487_(1));
        this.potionType = type;
    }

    public String m_5671_(ItemStack stack) {
        return this.m_5524_() + ".effect." + PotionHelper.getAdvancedPotion(stack).getId();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean m_5812_(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack m_7968_() {
        ItemStack stack = super.m_7968_().m_41777_();
        PotionHelper.setAdvancedPotion(stack, EnigmaticPotions.EMPTY_POTION);
        return stack.m_41777_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        SuperpositionHandler.addPotionTooltip(PotionHelper.getEffects(stack), stack, list, 1.0f);
    }

    @Override
    public CreativeModeTab getCreativeTab() {
        return EnigmaticTabs.POTIONS;
    }

    @Override
    public List<ItemStack> getCreativeTabStacks() {
        ImmutableList.Builder items = ImmutableList.builder();
        if (this.potionType == IAdvancedPotionItem.PotionType.COMMON) {
            for (AdvancedPotion potion : EnigmaticPotions.COMMON_POTIONS) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemNBTHelper.setString(stack, "EnigmaticPotion", potion.getId());
                items.add((Object)stack);
            }
        } else {
            for (AdvancedPotion potion : EnigmaticPotions.ULTIMATE_POTIONS) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemNBTHelper.setString(stack, "EnigmaticPotion", potion.getId());
                items.add((Object)stack);
            }
        }
        return items.build();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        ItemStack throwed = playerIn.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack.m_41620_(1);
        worldIn.m_6263_((Player)null, playerIn.m_20185_(), playerIn.m_20186_(), playerIn.m_20189_(), SoundEvents.f_12091_, SoundSource.PLAYERS, 0.5f, 0.4f / (random.nextFloat() * 0.4f + 0.8f));
        if (!worldIn.f_46443_) {
            EnigmaticPotionEntity potionEntity = new EnigmaticPotionEntity(worldIn, (LivingEntity)playerIn);
            potionEntity.m_37446_(throwed);
            potionEntity.m_37251_((Entity)playerIn, playerIn.m_146909_(), playerIn.m_146908_(), -20.0f, 0.5f, 1.0f);
            potionEntity.m_5602_((Entity)playerIn);
            worldIn.m_7967_((Entity)potionEntity);
        }
        playerIn.m_36246_(Stats.f_12982_.m_12902_((Object)this));
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)itemstack);
    }

    @Override
    public IAdvancedPotionItem.PotionType getPotionType() {
        return this.potionType;
    }
}

