/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.enigmaticlegacy.items;

import com.aizistral.enigmaticlegacy.EnigmaticLegacy;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.IMultiblockMiningTool;
import com.aizistral.enigmaticlegacy.api.materials.EnigmaticMaterials;
import com.aizistral.enigmaticlegacy.config.EtheriumConfigHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.AOEMiningHelper;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseTool;
import com.aizistral.enigmaticlegacy.packets.clients.PacketFlameParticles;
import com.aizistral.omniconfig.Configuration;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import com.google.common.collect.Sets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.PacketDistributor;

public class AstralBreaker
extends ItemBaseTool
implements IMultiblockMiningTool {
    public static Omniconfig.IntParameter miningRadius;
    public static Omniconfig.IntParameter miningDepth;
    public static Omniconfig.BooleanParameter flameParticlesToggle;

    @SubscribeConfig(receiveClient=true)
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("AstralBreaker");
        if (builder.config.getSidedType() != Configuration.SidedConfigType.CLIENT) {
            miningRadius = builder.comment("The radius of Astral Breaker AOE mining. Set to -1 to disable the feature.").min(-1.0).max(127.0).getInt("MiningRadius", 3);
            miningDepth = builder.comment("The depth of Astral Breaker AOE mining.").max(127.0).getInt("MiningDepth", 1);
        } else {
            flameParticlesToggle = builder.comment("Whether or not flame particles should appear when the Astral Breaker breaks a block").getBoolean("FlameParticlesToggle", true);
        }
        builder.popPrefix();
    }

    public AstralBreaker() {
        super(4.0f, -2.8f, EnigmaticMaterials.ETHERIUM, ItemBaseTool.getDefaultProperties().m_41499_(4000).m_41497_(Rarity.EPIC).m_41486_(), Sets.newHashSet((Object[])new TagKey[]{BlockTags.f_144282_, BlockTags.f_144280_, BlockTags.f_144283_, BlockTags.f_144281_}));
    }

    private Item findTool(String name) {
        return SuperpositionHandler.findItem("enigmaticlegacy", name);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.astralBreaker1", ChatFormatting.GOLD, miningRadius.getValue() + EtheriumConfigHandler.instance().getAOEBoost((Player)Minecraft.m_91087_().f_91074_), miningDepth.getValue());
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.astralBreaker2");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.astralBreaker3");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.astralBreaker4");
        } else {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.holdShift");
        }
        if (!this.areaEffectsAllowed(stack)) {
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, "tooltip.enigmaticlegacy.aoeDisabled");
        }
    }

    public void spawnFlameParticles(Level world, BlockPos pos) {
        EnigmaticLegacy.packetInstance.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 128.0, world.m_46472_())), (Object)new PacketFlameParticles((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 18, true));
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        BlockHitResult trace;
        Player player;
        if (!world.f_46443_) {
            this.spawnFlameParticles(world, pos);
        }
        if (entityLiving instanceof Player && this.areaEffectsEnabled(player = (Player)entityLiving, stack) && this.isCorrectToolForDrops(stack, state) && !world.f_46443_ && miningRadius.getValue() != -1 && (trace = AOEMiningHelper.calcRayTrace(world, player, ClipContext.Fluid.ANY)).m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockTrace = trace;
            Direction face = blockTrace.m_82434_();
            AOEMiningHelper.harvestCube(world, player, face, pos, s -> this.isCorrectToolForDrops(stack, (BlockState)s), miningRadius.getValue() + EtheriumConfigHandler.instance().getAOEBoost(player), miningDepth.getValue(), true, pos, stack, (objPos, objState) -> {
                stack.m_41622_(1, entityLiving, p -> p.m_21166_(Mob.m_147233_((ItemStack)stack)));
                this.spawnFlameParticles(world, (BlockPos)objPos);
            });
        }
        return super.m_6813_(stack, world, state, pos, entityLiving);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        if (player.m_6047_()) {
            this.toggleAreaEffects(player, stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return super.m_7203_(world, player, hand);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (context.m_43723_().m_6047_()) {
            return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
        }
        return super.m_6225_(context);
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == ToolActions.AXE_DIG || toolAction == ToolActions.PICKAXE_DIG || toolAction == ToolActions.SHOVEL_DIG || toolAction == ToolActions.HOE_DIG || toolAction == ToolActions.SWORD_DIG;
    }
}

