/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.registry;

import com.legacy.lucent.core.LucentConfig;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

@OnlyIn(value=Dist.CLIENT)
public class EntityLightSourcePosRegistry {
    public static final Map<EntityType<?>, Function<Entity, Vec3>> REGISTRY = new HashMap();
    private final BiConsumer<EntityType<?>, Function<Entity, Vec3>> register;

    public EntityLightSourcePosRegistry(BiConsumer<EntityType<?>, Function<Entity, Vec3>> register) {
        this.register = register;
    }

    public <T extends Entity> void register(EntityType<T> entityType, Function<T, Vec3> positionGetter) {
        this.register.accept(entityType, positionGetter);
    }

    public void register(ResourceLocation entityTypeId, Function<Entity, Vec3> positionGetter) {
        if (ForgeRegistries.ENTITY_TYPES.containsKey(entityTypeId)) {
            this.register((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId), positionGetter);
        } else if (((Boolean)LucentConfig.CLIENT.logRegistry.get()).booleanValue()) {
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + entityTypeId + "] was not found in registry", new Object[0]);
        }
    }

    public void register(String entityTypeId, Function<Entity, Vec3> positionGetter) {
        this.register(new ResourceLocation(entityTypeId), positionGetter);
    }

    public static Vec3 get(Entity entity) {
        Function<Entity, Vec3> getter = REGISTRY.get(entity.m_6095_());
        if (getter != null) {
            return getter.apply(entity);
        }
        return new Vec3(entity.m_20185_(), (double)entity.m_20206_() / 2.0 + entity.m_20186_(), entity.m_20189_());
    }
}

