/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.lucent.api.data.objects;

import com.legacy.lucent.api.data.objects.LightLevelProvider;
import com.legacy.lucent.core.LucentMod;
import com.legacy.lucent.core.LucentRegistry;
import com.legacy.lucent.core.data.managers.DatapackType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;

public class ItemLighting {
    private static final Codec<ItemLighting> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.f_257033_.m_194605_().optionalFieldOf("id").forGetter(r -> r.item), (App)LightLevelProvider.codec(LightLevelProvider.Source.ITEM_STACK).fieldOf("light").forGetter(r -> r.provider), (App)Codec.BOOL.optionalFieldOf("works_underwater", (Object)true).forGetter(r -> r.worksUnderwater), (App)Codec.BOOL.optionalFieldOf("works_on_land", (Object)true).forGetter(r -> r.worksOnLand)).apply((Applicative)instance, ItemLighting::new));
    public static final DatapackType<ResourceLocation, ItemLighting> TYPE = DatapackType.byName(ItemLighting.class, "dynamic_lighting/item", CODEC);
    private final Optional<Item> item;
    private final LightLevelProvider<?> provider;
    private final boolean worksUnderwater;
    private final boolean worksOnLand;

    private ItemLighting(Optional<Item> item, LightLevelProvider<?> provider, boolean worksUnderwater, boolean worksOnLand) {
        this.item = item;
        this.provider = provider;
        this.worksUnderwater = worksUnderwater;
        this.worksOnLand = worksOnLand;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Optional<Item> item() {
        return this.item;
    }

    public LightLevelProvider<?> provider() {
        return this.provider;
    }

    public boolean worksUnderwater() {
        return this.worksUnderwater;
    }

    public boolean worksOnLand() {
        return this.worksOnLand;
    }

    public static class Builder {
        Optional<Item> item = Optional.empty();
        LightLevelProvider<?> provider = LightLevelProvider.Direct.MAX_LIGHTING;
        boolean worksUnderwater = true;
        boolean worksOnLand = true;
        boolean failed = false;

        private Builder() {
        }

        public Builder item(@Nullable Item item) {
            this.item = Optional.ofNullable(item);
            return this;
        }

        public Builder item(ResourceLocation itemID) {
            if (BuiltInRegistries.f_257033_.m_7804_(itemID)) {
                return this.item((Item)BuiltInRegistries.f_257033_.m_7745_(itemID));
            }
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + itemID + "] was not found in registry", new Object[0]);
            this.failed = true;
            return this;
        }

        public Builder item(String itemID) {
            if (ResourceLocation.m_135830_((String)itemID)) {
                return this.item(new ResourceLocation(itemID));
            }
            LucentMod.LOGGER.warn("  [" + LucentRegistry.sourceName + "] -> [" + itemID + "] is not a valid resource location", new Object[0]);
            this.failed = true;
            return this;
        }

        public Builder light(LightLevelProvider<?> provider) {
            this.provider = provider;
            return this;
        }

        public Builder light(int light) {
            return this.light(new LightLevelProvider.Direct(light));
        }

        public Builder light(Block block) {
            return this.light(new LightLevelProvider.MatchBlock(block));
        }

        public Builder light(Function<ItemStack, Integer> function) {
            return this.light(new LightLevelProvider.Custom<ItemStack>(function));
        }

        public Builder worksUnderwater(boolean worksUnderwater) {
            this.worksUnderwater = worksUnderwater;
            return this;
        }

        public Builder worksOnLand(boolean worksOnLand) {
            this.worksOnLand = worksOnLand;
            return this;
        }

        public boolean hasFailed() {
            return this.failed;
        }

        public ItemLighting build() {
            return new ItemLighting(this.item, this.provider, this.worksUnderwater, this.worksOnLand);
        }
    }
}

