/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.biomes;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.floats.Float2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.floats.Float2ObjectSortedMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import twilightforest.init.TFBiomes;
import twilightforest.init.TFLandmark;
import twilightforest.world.components.chunkgenerators.warp.TerrainColumn;
import twilightforest.world.registration.biomes.BiomeHelper;

public final class BiomeMaker
extends BiomeHelper {
    public static final Map<ResourceKey<Biome>, ImmutableSet<TFLandmark>> BIOME_FEATURES_SETS = new ImmutableMap.Builder().put(TFBiomes.ENCHANTED_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.QUEST_GROVE)).put(TFBiomes.SWAMP, (Object)ImmutableSet.of((Object)TFLandmark.LABYRINTH)).put(TFBiomes.FIRE_SWAMP, (Object)ImmutableSet.of((Object)TFLandmark.HYDRA_LAIR)).put(TFBiomes.DARK_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.KNIGHT_STRONGHOLD)).put(TFBiomes.DARK_FOREST_CENTER, (Object)ImmutableSet.of((Object)TFLandmark.DARK_TOWER)).put(TFBiomes.SNOWY_FOREST, (Object)ImmutableSet.of((Object)TFLandmark.YETI_CAVE)).put(TFBiomes.GLACIER, (Object)ImmutableSet.of((Object)TFLandmark.ICE_TOWER)).put(TFBiomes.HIGHLANDS, (Object)ImmutableSet.of((Object)TFLandmark.TROLL_CAVE)).put(TFBiomes.FINAL_PLATEAU, (Object)ImmutableSet.of((Object)TFLandmark.FINAL_CASTLE)).build();

    public static List<TerrainColumn> makeBiomeList(HolderGetter<Biome> biomeRegistry, Holder<Biome> undergroundBiome) {
        return List.of(BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.1f, 0.2f, biomeRegistry, TFBiomes.DENSE_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.0625f, 0.05f, biomeRegistry, TFBiomes.FIREFLY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.005f, 0.005f, biomeRegistry, TFBiomes.CLEARING, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.1f, biomeRegistry, TFBiomes.OAK_SAVANNAH, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-1.65f, 0.25f, biomeRegistry, TFBiomes.STREAM, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-1.97f, 0.0f, biomeRegistry, TFBiomes.LAKE, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.MUSHROOM_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.05f, biomeRegistry, TFBiomes.DENSE_MUSHROOM_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.ENCHANTED_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.SPOOKY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-0.9f, 0.15f, biomeRegistry, TFBiomes.SWAMP, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(-0.2f, 0.05f, biomeRegistry, TFBiomes.FIRE_SWAMP, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.005f, biomeRegistry, TFBiomes.DARK_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.005f, biomeRegistry, TFBiomes.DARK_FOREST_CENTER, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.05f, 0.15f, biomeRegistry, TFBiomes.SNOWY_FOREST, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(0.025f, 0.05f, biomeRegistry, TFBiomes.GLACIER, undergroundBiome), BiomeMaker.biomeColumnWithUnderground(3.0f, 0.25f, biomeRegistry, TFBiomes.HIGHLANDS, undergroundBiome), BiomeMaker.biomeColumnToBedrock(7.0f, 0.1f, biomeRegistry, TFBiomes.THORNLANDS), BiomeMaker.biomeColumnToBedrock(13.75f, 0.025f, biomeRegistry, TFBiomes.FINAL_PLATEAU));
    }

    private static TerrainColumn biomeColumnWithUnderground(float noiseDepth, float noiseScale, HolderGetter<Biome> biomeRegistry, ResourceKey<Biome> key, Holder<Biome> undergroundBiome) {
        Holder.Reference biomeHolder = biomeRegistry.m_255043_(key);
        biomeHolder.m_246870_(key);
        return BiomeMaker.makeColumn(noiseDepth, noiseScale, (Holder<Biome>)biomeHolder, treeMap -> {
            treeMap.put(Math.min(noiseDepth - 1.0f, -1.0f), (Object)biomeHolder);
            treeMap.put(Math.min(noiseDepth - 3.0f, -3.0f), (Object)undergroundBiome);
        });
    }

    private static TerrainColumn biomeColumnToBedrock(float noiseDepth, float noiseScale, HolderGetter<Biome> biomeRegistry, ResourceKey<Biome> key) {
        Holder.Reference biomeHolder = biomeRegistry.m_255043_(key);
        biomeHolder.m_246870_(key);
        return BiomeMaker.makeColumn(noiseDepth, noiseScale, (Holder<Biome>)biomeHolder, treeMap -> treeMap.put(0.0f, (Object)biomeHolder));
    }

    private static TerrainColumn makeColumn(float noiseDepth, float noiseScale, Holder<Biome> biomeHolder, Consumer<Float2ObjectSortedMap<Holder<Biome>>> layerBuilder) {
        return new TerrainColumn(biomeHolder, (Float2ObjectSortedMap<Holder<Biome>>)((Float2ObjectSortedMap)Util.m_137469_((Object)new Float2ObjectAVLTreeMap(), layerBuilder)), noiseDepth, noiseScale);
    }
}

