/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtowerrevamp;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import twilightforest.TwilightForestMod;
import twilightforest.init.TFStructurePieceTypes;
import twilightforest.world.components.processors.BoxCuttingProcessor;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;
import twilightforest.world.components.structures.lichtowerrevamp.BossRoom;
import twilightforest.world.components.structures.lichtowerrevamp.CentralTowerAttachment;
import twilightforest.world.components.structures.lichtowerrevamp.CentralTowerSegment;
import twilightforest.world.components.structures.lichtowerrevamp.LichTowerUtil;

public final class TowerFoyer
extends TwilightTemplateStructurePiece {
    public TowerFoyer(StructurePieceSerializationContext ctx, CompoundTag compoundTag) {
        super((StructurePieceType)TFStructurePieceTypes.TOWER_FOYER.get(), compoundTag, ctx, TowerFoyer.readSettings(compoundTag));
    }

    public TowerFoyer(StructureTemplateManager structureManager, BlockPos startPosition) {
        super((StructurePieceType)TFStructurePieceTypes.TOWER_FOYER.get(), 0, structureManager, TwilightForestMod.prefix("lich_tower/foyer"), TowerFoyer.makeSettings(Rotation.NONE), startPosition.m_6630_(3));
    }

    public void m_214092_(StructurePiece parent, StructurePieceAccessor structureStart, RandomSource random) {
        super.m_214092_(parent, structureStart, random);
        int randomCountTowerSegments = random.m_188503_(5) + 15;
        Direction front = this.f_73379_.m_55954_(Direction.NORTH);
        BlockPos center = this.f_73383_.m_162394_();
        BlockPos centralTowerOrigin = new BlockPos(center.m_123341_() - 15, this.f_73383_.m_162400_() - 30, center.m_123343_() - 15);
        HashMap<BlockPos, Direction> sideTowerStarts = new HashMap<BlockPos, Direction>();
        int totalSegments = (randomCountTowerSegments >> 1) - 2;
        this.beginSideTowers(structureStart, random, totalSegments, 0, front, Rotation.CLOCKWISE_90, centralTowerOrigin, sideTowerStarts);
        this.beginSideTowers(structureStart, random, totalSegments, 0, front, Rotation.COUNTERCLOCKWISE_90, centralTowerOrigin, sideTowerStarts);
        this.beginSideTowers(structureStart, random, totalSegments, 7, front, Rotation.NONE, centralTowerOrigin, sideTowerStarts);
        this.beginSideTowers(structureStart, random, totalSegments, 7, front, Rotation.CLOCKWISE_180, centralTowerOrigin, sideTowerStarts);
        BoxCuttingProcessor cuttingProcessor = BoxCuttingProcessor.forLichTower(sideTowerStarts);
        Rotation climbingRotation = this.f_73379_;
        for (int i = 0; i < randomCountTowerSegments; ++i) {
            CentralTowerSegment towerSegment = new CentralTowerSegment(this.structureManager, climbingRotation, cuttingProcessor, StructureTemplate.m_74587_((BlockPos)centralTowerOrigin, (Mirror)Mirror.NONE, (Rotation)climbingRotation, (int)30, (int)30).m_6630_(i * 4));
            towerSegment.m_214092_((StructurePiece)this, structureStart, random);
            structureStart.m_142679_((StructurePiece)towerSegment);
            climbingRotation = climbingRotation.m_55952_(this.f_73378_ == Mirror.NONE ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
        }
        BossRoom bossRoom = new BossRoom(this.structureManager, climbingRotation, cuttingProcessor, StructureTemplate.m_74587_((BlockPos)centralTowerOrigin, (Mirror)Mirror.NONE, (Rotation)climbingRotation, (int)44, (int)44).m_6630_(randomCountTowerSegments * 4).m_122025_(7).m_122013_(7));
        bossRoom.m_214092_((StructurePiece)this, structureStart, random);
        structureStart.m_142679_((StructurePiece)bossRoom);
    }

    private void beginSideTowers(StructurePieceAccessor structureStart, RandomSource random, int totalSegments, int segmentStart, Direction front, Rotation fromFront, BlockPos centralTowerOrigin, Map<BlockPos, Direction> sideTowerStarts) {
        for (int i = segmentStart; i < totalSegments; ++i) {
            float weight = (float)i / (float)totalSegments * 2.0f;
            if (!(random.m_188501_() < weight)) continue;
            Rotation relativeRotation = fromFront.m_55952_(this.f_73379_);
            Direction sideTowerDirection = relativeRotation.m_55954_(front);
            BlockPos sideTowerPos = LichTowerUtil.getRandomOpeningPlacementPos(centralTowerOrigin, sideTowerDirection, Mirror.NONE, random, i << 1, this.f_73379_ == Rotation.NONE || this.f_73379_ == Rotation.CLOCKWISE_180);
            sideTowerStarts.put(sideTowerPos.m_121945_(sideTowerDirection), sideTowerDirection);
            CentralTowerAttachment sideTower = CentralTowerAttachment.startRandomAttachment(this.structureManager, relativeRotation, sideTowerPos.m_5484_(sideTowerDirection, 2), random);
            sideTower.m_214092_((StructurePiece)this, structureStart, random);
            structureStart.m_142679_((StructurePiece)sideTower);
        }
    }

    public void m_213694_(WorldGenLevel level, StructureManager structureFeatureManager, ChunkGenerator chunkGenerator, RandomSource random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos pos) {
        this.placePieceAdjusted(level, structureFeatureManager, chunkGenerator, random, boundingBox, chunkPos, pos, -3);
        BlockPos placement = new BlockPos(this.f_73383_.m_162394_().m_123341_() + 1, this.f_73383_.m_162396_() + 7, this.f_73383_.m_162398_() + 16);
        if (boundingBox.m_71051_((Vec3i)placement)) {
            ArmorStand armorStand = new ArmorStand(EntityType.f_20529_, (Level)level.m_6018_());
            armorStand.m_6593_((Component)Component.m_237113_((String)"Welcome to the new Lich Tower! The design is heavily WIP and will be fleshed out significantly in later development builds"));
            armorStand.m_7678_((double)placement.m_123341_(), (double)placement.m_123342_() + 0.5, (double)placement.m_123343_() + 0.5, 0.0f, 0.0f);
            armorStand.m_20331_(true);
            armorStand.m_6842_(true);
            armorStand.m_20340_(true);
            armorStand.m_20225_(true);
            armorStand.m_20242_(true);
            armorStand.m_20088_().m_135381_(ArmorStand.f_31524_, (Object)((byte)((Byte)armorStand.m_20088_().m_135370_(ArmorStand.f_31524_) | 0x10)));
            level.m_7967_((Entity)armorStand);
        }
    }

    protected void m_213704_(String label, BlockPos pos, ServerLevelAccessor levelAccessor, RandomSource random, BoundingBox boundingBox) {
    }
}

