/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.placements;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import twilightforest.init.TFFeatureModifiers;
import twilightforest.util.LandmarkUtil;
import twilightforest.util.LegacyLandmarkPlacements;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.components.structures.util.DecorationClearance;

public class AvoidLandmarkModifier
extends PlacementModifier {
    public static final Codec<AvoidLandmarkModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("occupies_surface").forGetter(o -> o.occupiesSurface), (App)Codec.BOOL.fieldOf("occupies_underground").forGetter(o -> o.occupiesUnderground), (App)Codec.INT.fieldOf("additional_clearance").forGetter(o -> o.additionalClearance)).apply((Applicative)instance, AvoidLandmarkModifier::new)).flatXmap(AvoidLandmarkModifier::validate, AvoidLandmarkModifier::validate);
    private final boolean occupiesSurface;
    private final boolean occupiesUnderground;
    private final int additionalClearance;

    public AvoidLandmarkModifier(boolean occupiesSurface, boolean occupiesUnderground, int additionalClearance) {
        this.occupiesSurface = occupiesSurface;
        this.occupiesUnderground = occupiesUnderground;
        this.additionalClearance = additionalClearance;
    }

    public static AvoidLandmarkModifier checkSurface() {
        return new AvoidLandmarkModifier(true, false, 0);
    }

    public static AvoidLandmarkModifier checkUnderground() {
        return new AvoidLandmarkModifier(false, true, 0);
    }

    public static AvoidLandmarkModifier checkBoth() {
        return new AvoidLandmarkModifier(true, true, 0);
    }

    public Stream<BlockPos> m_213676_(PlacementContext worldDecoratingHelper, RandomSource random, BlockPos blockPos) {
        Structure structure;
        if (!(worldDecoratingHelper.m_191831_().m_6018_().m_7726_().m_8481_() instanceof ChunkGeneratorTwilight)) {
            return Stream.of(blockPos);
        }
        BlockPos.MutableBlockPos featurePos = LegacyLandmarkPlacements.getNearestCenterXZ(blockPos.m_123341_() >> 4, blockPos.m_123343_() >> 4).m_122032_();
        Optional<StructureStart> possibleStructureStart = LandmarkUtil.locateNearestLandmarkStart((LevelAccessor)worldDecoratingHelper.m_191831_(), SectionPos.m_123171_((int)featurePos.m_123341_()), SectionPos.m_123171_((int)featurePos.m_123343_()));
        if (possibleStructureStart.isEmpty() || !((structure = possibleStructureStart.get().m_226861_()) instanceof DecorationClearance)) {
            return Stream.of(blockPos);
        }
        DecorationClearance decorationClearance = (DecorationClearance)structure;
        if (!(this.occupiesSurface && !decorationClearance.isSurfaceDecorationsAllowed() || this.occupiesUnderground && !decorationClearance.isUndergroundDecoAllowed())) {
            return Stream.of(blockPos);
        }
        featurePos.m_122178_(Math.abs(featurePos.m_123341_() - blockPos.m_123341_()), 0, Math.abs(featurePos.m_123343_() - blockPos.m_123343_()));
        int size = decorationClearance.chunkClearanceRadius() * 16 + this.additionalClearance;
        return featurePos.m_123341_() < size && featurePos.m_123343_() < size ? Stream.empty() : Stream.of(blockPos);
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)TFFeatureModifiers.NO_STRUCTURE.get();
    }

    private static DataResult<AvoidLandmarkModifier> validate(AvoidLandmarkModifier config) {
        return config.occupiesSurface || config.occupiesUnderground ? DataResult.success((Object)((Object)config)) : DataResult.error(() -> "Feature Decorator cannot occupy neither surface nor underground");
    }
}

