/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.objects;

import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import com.aizistral.enigmaticlegacy.config.OmniconfigHandler;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class SpecialLootModifier
extends LootModifier {
    public static final Supplier<Codec<SpecialLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> SpecialLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, SpecialLootModifier::new)));

    protected SpecialLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        ServerLevel level = context.m_78952_();
        Entity entity = (Entity)context.m_78953_(LootContextParams.f_81455_);
        Vec3 origin = (Vec3)context.m_78953_(LootContextParams.f_81460_);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (SuperpositionHandler.hasPersistentTag((Player)player, (String)"LootedHellCharm")) {
                generatedLoot.removeIf(stack -> stack.m_150930_((Item)EnigmaticAddonItems.HELL_BLADE_CHARM));
            } else if (generatedLoot.stream().anyMatch(stack -> stack.m_150930_((Item)EnigmaticAddonItems.HELL_BLADE_CHARM))) {
                SuperpositionHandler.setPersistentBoolean((Player)player, (String)"LootedHellCharm", (boolean)true);
            }
            if (OmniconfigHandler.isItemEnabled((Object)EnigmaticItems.EARTH_HEART) && level.f_46441_.m_188503_(3) == 0 && generatedLoot.stream().anyMatch(stack -> stack.m_150930_((Item)EnigmaticItems.IRON_RING))) {
                generatedLoot.removeIf(stack -> stack.m_150930_((Item)EnigmaticItems.IRON_RING));
                generatedLoot.add((Object)new ItemStack((ItemLike)EnigmaticAddonItems.EARTH_HEART_FRAGMENT, level.f_46441_.m_188503_(2) + 1));
            }
            if (SuperpositionHandler.hasPersistentTag((Player)player, (String)"LootedVoidTome")) {
                generatedLoot.removeIf(stack -> stack.m_150930_((Item)EnigmaticAddonItems.VOID_TOME));
            } else if (generatedLoot.stream().anyMatch(stack -> stack.m_150930_((Item)EnigmaticAddonItems.VOID_TOME))) {
                SuperpositionHandler.setPersistentBoolean((Player)player, (String)"LootedVoidTome", (boolean)true);
            }
        }
        return generatedLoot;
    }

    public Codec<SpecialLootModifier> codec() {
        return CODEC.get();
    }
}

