/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.api.items.ISpellstone;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.generic.ItemSpellstoneCurio;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ForgottenIce
extends ItemSpellstoneCurio
implements ISpellstone {
    public static Omniconfig.IntParameter spellstoneCooldown;
    public static Omniconfig.PerhapsParameter frostBoost;
    public static Omniconfig.PerhapsParameter multiResistance;
    public static Omniconfig.DoubleParameter spellstoneDamage;

    public ForgottenIce() {
        super(ItemSpellstoneCurio.getDefaultProperties().m_41497_(Rarity.RARE));
        this.immunityList.add(DamageTypes.f_268444_);
        float modifier = multiResistance.getValue().asModifierInverted();
        this.resistanceList.put(DamageTypes.f_268534_, () -> Float.valueOf(modifier));
        this.resistanceList.put(DamageTypes.f_268679_, () -> Float.valueOf(modifier));
        this.resistanceList.put(DamageTypes.f_268631_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268468_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268546_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268434_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268684_, () -> Float.valueOf(2.0f));
        this.resistanceList.put(DamageTypes.f_268671_, () -> Float.valueOf(1.25f));
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("ForgottenIceCrystal");
        spellstoneCooldown = builder.comment("Active ability cooldown for Forgotten Ice Crystal. Measured in ticks. 20 ticks equal to 1 second.").getInt("Cooldown", 300);
        spellstoneDamage = builder.comment("The damage of ability of Forgotten Ice Crystal.").getDouble("Damage", 2.0);
        frostBoost = builder.comment("The damage boost on target which has been fully frozen. Defined as percentage.").max(256.0).getPerhaps("FrostBoost", 25);
        multiResistance = builder.comment("Resistance to projectile and sonic attacks provided by Forgotten Ice Crysta. Defined as percentage.").max(100.0).getPerhaps("Resistance", 30);
        builder.popPrefix();
    }

    public int getCooldown(Player player) {
        return player != null && reducedCooldowns.test(player) ? 15 : spellstoneCooldown.getValue();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIceCooldown", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{Float.valueOf((float)this.getCooldown((Player)Minecraft.m_91087_().f_91074_) / 20.0f)});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce3");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce4");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce6");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce7");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce8", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{multiResistance + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.forgottenIce9");
        } else {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
        try {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.currentKeybind", (ChatFormatting)ChatFormatting.LIGHT_PURPLE, (Object[])new Object[]{((Component)KeyMapping.m_90842_((String)"key.spellstoneAbility").get()).getString().toUpperCase()});
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void triggerActiveAbility(Level world, ServerPlayer player, ItemStack stack) {
        if (!SuperpositionHandler.hasSpellstoneCooldown((Player)player)) {
            ItemParticleOption particle = new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Blocks.f_50568_));
            SimpleParticleType snowflake = ParticleTypes.f_175821_;
            List entities = player.m_9236_().m_45976_(LivingEntity.class, player.m_20191_().m_82400_(5.0));
            for (LivingEntity entity : entities) {
                if (entity.m_7306_((Entity)player)) continue;
                if (entity.m_142079_()) {
                    entity.m_146917_(entity.m_146888_() + 500);
                }
                entity.m_6469_(player.m_269291_().m_269298_(DamageTypes.f_268444_, (Entity)player), (float)spellstoneDamage.getValue());
                float width = entity.m_20205_() / 1.8f;
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)particle, entity.m_20185_(), entity.m_20227_((double)0.8f), entity.m_20189_(), 16, (double)width, 0.1, (double)width, 0.0);
                ((ServerLevel)entity.m_9236_()).m_8767_((ParticleOptions)snowflake, entity.m_20185_(), entity.m_20227_((double)0.8f), entity.m_20189_(), 10, (double)width, 0.1, (double)width, 0.0);
            }
            ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)snowflake, player.m_20185_(), player.m_20227_(0.5), player.m_20189_(), 36, 0.1, 0.1, 0.1, 0.3);
            SuperpositionHandler.setSpellstoneCooldown((Player)player, (int)this.getCooldown((Player)player));
        }
    }
}

