/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.items;

import auviotre.enigmatic.addon.handlers.SuperAddonHandler;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.triggers.BlessRingEquippedTrigger;
import com.aizistral.enigmaticlegacy.api.generic.SubscribeConfig;
import com.aizistral.enigmaticlegacy.handlers.SuperpositionHandler;
import com.aizistral.enigmaticlegacy.helpers.ItemLoreHelper;
import com.aizistral.enigmaticlegacy.items.CursedRing;
import com.aizistral.enigmaticlegacy.items.generic.ItemBaseCurio;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.omniconfig.wrappers.Omniconfig;
import com.aizistral.omniconfig.wrappers.OmniconfigWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class BlessRing
extends ItemBaseCurio {
    public static final List<String> blessList = new ArrayList<String>();
    public static final String CURSED_SPAWN = "CursedNextSpawn";
    public static final String BLESS_SPAWN = "BlessNextSpawn";
    public static Omniconfig.PerhapsParameter damageResistance;
    public static Omniconfig.PerhapsParameter damageBoost;
    public static Omniconfig.IntParameter regenerationSpeed;

    public BlessRing() {
        super(ItemBaseCurio.getDefaultProperties().m_41497_(Rarity.EPIC).m_41486_());
        blessList.add("enigmaticlegacy:astral_fruit");
        blessList.add("enigmaticlegacy:twisted_mirror");
        blessList.add("enigmaticlegacy:infernal_shield");
        blessList.add("enigmaticlegacy:berserk_charm");
        blessList.add("enigmaticlegacy:enchanter_pearl");
        blessList.add("enigmaticlegacy:guardian_heart");
        blessList.add("enigmaticlegacy:twisted_heart");
        blessList.add("enigmaticlegacy:curse_transposer");
        blessList.add("enigmaticaddons:night_scroll");
        blessList.add("enigmaticaddons:sanguinary_handbook");
        blessList.add("enigmaticaddons:earth_promise");
        blessList.add("enigmaticaddons:thunder_scroll");
        blessList.add("enigmaticaddons:pure_heart");
        blessList.add("enigmaticaddons:bless_amplifier");
        blessList.add("enigmaticaddons:the_bless");
        blessList.add("enigmaticaddons:scorched_charm");
    }

    @SubscribeConfig
    public static void onConfig(OmniconfigWrapper builder) {
        builder.pushPrefix("RingofRedemption");
        damageResistance = builder.comment("The damage resistance of the Ring of Redemption. Measured in percentage.").min(0.0).max(100.0).getPerhaps("DamageResistance", 40);
        damageBoost = builder.comment("The damage boost of the Ring of Redemption. Measured in percentage.").min(0.0).max(500.0).getPerhaps("DamageBoost", 20);
        regenerationSpeed = builder.comment("The time required for each regeneration of Ring of Redemption. Measured in ticks.").min(5.0).getInt("RegenerationTick", 20);
        builder.popPrefix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> list, TooltipFlag flagIn) {
        ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
        if (Screen.m_96638_()) {
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing1");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing2");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing3", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{100 - damageResistance.getValue().asPercentage() + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing4", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{damageBoost + "%"});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing5");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing6", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{(CursedRing.lootingBonus.getValue() + 1) / 2});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing7", (ChatFormatting)ChatFormatting.GOLD, (Object[])new Object[]{(CursedRing.fortuneBonus.getValue() + 1) / 2});
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing8");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRing9");
        } else {
            if (CursedRing.enableLore.getValue()) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingLore1");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingLore2");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingLore3");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticaddons.blessRingLore4");
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound1");
            if (Minecraft.m_91087_().f_91074_ != null && SuperpositionHandler.canUnequipBoundRelics((Player)Minecraft.m_91087_().f_91074_)) {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound2_creative");
            } else {
                ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.eternallyBound2");
            }
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.void");
            ItemLoreHelper.addLocalizedString(list, (String)"tooltip.enigmaticlegacy.holdShift");
        }
    }

    public List<Component> getAttributesTooltip(List<Component> tooltips, ItemStack stack) {
        tooltips.clear();
        return tooltips;
    }

    public boolean canUnequip(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof Player && SuperpositionHandler.canUnequipBoundRelics((Player)(player = (Player)livingEntity))) {
            return super.canUnequip(context, stack);
        }
        return false;
    }

    public void onEquip(SlotContext context, ItemStack prevStack, ItemStack stack) {
        LivingEntity livingEntity = context.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            BlessRingEquippedTrigger.INSTANCE.trigger(player);
        }
    }

    public void curioTick(SlotContext context, ItemStack stack) {
        Player player;
        LivingEntity entity = context.entity();
        if (entity instanceof Player && SuperAddonHandler.isPunishedOne((LivingEntity)(player = (Player)entity))) {
            SuperpositionHandler.setPersistentInteger((Player)player, (String)"Punishment", (int)(1 + SuperpositionHandler.getPersistentInteger((Player)player, (String)"Punishment", (int)0)));
            if (SuperpositionHandler.getPersistentInteger((Player)player, (String)"Punishment", (int)0) % 20 == 0) {
                player.m_5496_(SoundEvents.f_12513_, 0.6f, 0.0f);
                Level level = player.m_9236_();
                if (!level.m_5776_()) {
                    ServerPlayer serverPlayer;
                    LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(player.m_9236_());
                    lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)player.m_20183_()));
                    lightningBolt.m_20879_(player instanceof ServerPlayer ? (serverPlayer = (ServerPlayer)player) : null);
                    player.m_9236_().m_7967_((Entity)lightningBolt);
                }
            }
            if (SuperpositionHandler.getPersistentInteger((Player)player, (String)"Punishment", (int)0) > 100) {
                SuperpositionHandler.removePersistentTag((Player)player, (String)"Punishment");
                SuperpositionHandler.destroyCurio((LivingEntity)player, (Item)EnigmaticAddonItems.BLESS_RING);
                SuperpositionHandler.destroyCurio((LivingEntity)player, (Item)EnigmaticItems.CURSED_RING);
                player.m_6469_(player.m_269291_().m_269341_(), player.m_21233_() * 1000.0f);
                player.f_36080_ = 0.0f;
                player.f_36078_ = 0;
                player.m_6074_();
            }
        }
        if (entity.f_19797_ % regenerationSpeed.getValue() == 0 && entity.m_21223_() < entity.m_21233_() * 0.9f) {
            float delta = entity.m_21233_() * 0.9f - entity.m_21223_();
            entity.m_5634_(delta / 20.0f);
        }
    }

    public boolean canEquip(SlotContext context, ItemStack stack) {
        if (super.canEquip(context, stack)) {
            Player player;
            LivingEntity livingEntity = context.entity();
            return livingEntity instanceof Player && !SuperpositionHandler.isTheCursedOne((Player)(player = (Player)livingEntity));
        }
        return false;
    }

    public boolean canEquipFromUse(SlotContext context, ItemStack stack) {
        return false;
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, int lootingLevel, boolean recentlyHit, ItemStack stack) {
        return ICurio.DropRule.ALWAYS_KEEP;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        Map list = EnchantmentHelper.m_44831_((ItemStack)book);
        return !list.containsKey(Enchantments.f_44963_) && super.isBookEnchantable(stack, book);
    }

    public int getFortuneLevel(SlotContext slotContext, LootContext lootContext, ItemStack curio) {
        return super.getFortuneLevel(slotContext, lootContext, curio) + (CursedRing.fortuneBonus.getValue() + 1) / 2;
    }

    public int getLootingLevel(SlotContext slotContext, DamageSource source, LivingEntity target, int baseLooting, ItemStack curio) {
        return super.getLootingLevel(slotContext, source, target, baseLooting, curio) + (CursedRing.lootingBonus.getValue() + 1) / 2;
    }
}

