/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.contents.crafting;

import auviotre.enigmatic.addon.contents.items.BlessAmplifier;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class EnchantmentAmplifierRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<EnchantmentAmplifierRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(EnchantmentAmplifierRecipe::new);

    public EnchantmentAmplifierRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack amplifier = null;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack checkedStack = craftingContainer.m_8020_(i);
            if (checkedStack.m_41619_()) continue;
            if (checkedStack.m_41720_() instanceof BlessAmplifier) {
                if (amplifier != null) {
                    return ItemStack.f_41583_;
                }
                amplifier = checkedStack.m_41777_();
                continue;
            }
            stackList.add(checkedStack);
        }
        if (amplifier != null && stackList.size() == 1 && ((ItemStack)stackList.get(0)).m_41793_() && this.canBoost(amplifier, (ItemStack)stackList.get(0))) {
            return this.boost((ItemStack)stackList.get(0));
        }
        return ItemStack.f_41583_;
    }

    public boolean matches(CraftingContainer craftingContainer, Level level) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        ItemStack amplifier = null;
        for (int i = 0; i < craftingContainer.m_6643_(); ++i) {
            ItemStack checkedStack = craftingContainer.m_8020_(i);
            if (checkedStack.m_41619_()) continue;
            if (checkedStack.m_41720_() instanceof BlessAmplifier) {
                if (amplifier != null) {
                    return false;
                }
                amplifier = checkedStack.m_41777_();
                continue;
            }
            stackList.add(checkedStack);
        }
        return amplifier != null && stackList.size() == 1 && ((ItemStack)stackList.get(0)).m_41793_() && this.canBoost(amplifier, (ItemStack)stackList.get(0));
    }

    private ItemStack boost(ItemStack target) {
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)target);
        for (Enchantment enchantment : enchantments.keySet()) {
            if (enchantment.m_6586_() <= 1 || enchantment.m_6586_() + 1 <= target.getEnchantmentLevel(enchantment)) continue;
            enchantments.compute(enchantment, (enchant, integer) -> Math.min(integer * 2, enchantment.m_6586_() + 1));
        }
        ItemStack item = target.m_41777_();
        EnchantmentHelper.m_44865_((Map)enchantments, (ItemStack)item);
        return item;
    }

    private boolean canBoost(ItemStack amplifier, ItemStack target) {
        Stream enchantments = EnchantmentHelper.m_44831_((ItemStack)target).keySet().stream();
        Objects.requireNonNull(amplifier.m_41720_());
        return enchantments.anyMatch(enchantment -> enchantment.m_6586_() > 1 && enchantment.m_6586_() + 1 > target.getEnchantmentLevel(enchantment));
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

