/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon.client.particles;

import auviotre.enigmatic.addon.registries.EnigmaticAddonParticles;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SimpleAnimatedParticle;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StarDustParticle
extends SimpleAnimatedParticle {
    protected StarDustParticle(ClientLevel level, int color, double posX, double posY, double posZ, double dx, double dy, double dz, SpriteSet spriteSet) {
        super(level, posX, posY, posZ, spriteSet, 0.0125f);
        this.f_107215_ = dx;
        this.f_107216_ = dy;
        this.f_107217_ = dz;
        this.f_107663_ *= 0.75f;
        this.f_172258_ = 0.775f;
        this.f_107226_ = (float)((double)0.08f + Math.random() * (double)0.04f);
        this.f_107225_ = 30 + this.f_107223_.m_188503_(20);
        this.m_107659_(color);
        this.m_108339_(spriteSet);
    }

    public static ParticleOptions get(RandomSource random) {
        return switch (random.m_188503_(3)) {
            case 0 -> EnigmaticAddonParticles.BLUE_STAR_DUST;
            case 1 -> EnigmaticAddonParticles.RED_STAR_DUST;
            default -> EnigmaticAddonParticles.PURPLE_STAR_DUST;
        };
    }

    public void m_5989_() {
        this.f_107226_ -= 0.012f;
        super.m_5989_();
    }

    public void m_6257_(double dx, double dy, double dz) {
        this.m_107259_(this.m_107277_().m_82386_(dx, dy, dz));
        this.m_107275_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class PurpleProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public PurpleProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double posX, double posY, double posZ, double speedX, double speedY, double speedZ) {
            return new StarDustParticle(level, 16422123, posX, posY, posZ, speedX, speedY, speedZ, this.sprites);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RedProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public RedProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double posX, double posY, double posZ, double speedX, double speedY, double speedZ) {
            return new StarDustParticle(level, 16742489, posX, posY, posZ, speedX, speedY, speedZ, this.sprites);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class BlueProvider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public BlueProvider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double posX, double posY, double posZ, double speedX, double speedY, double speedZ) {
            return new StarDustParticle(level, 12841470, posX, posY, posZ, speedX, speedY, speedZ, this.sprites);
        }
    }
}

