/*
 * Decompiled with CFR 0.152.
 */
package auviotre.enigmatic.addon;

import auviotre.enigmatic.addon.client.handlers.ClientEventHandler;
import auviotre.enigmatic.addon.contents.brewing.AstralBrewingRecipe;
import auviotre.enigmatic.addon.contents.objects.FilePackResources;
import auviotre.enigmatic.addon.handlers.AddonEventHandler;
import auviotre.enigmatic.addon.handlers.AddonKeybindHandler;
import auviotre.enigmatic.addon.handlers.OmniconfigAddonHandler;
import auviotre.enigmatic.addon.helpers.PotionAddonHelper;
import auviotre.enigmatic.addon.packets.clients.PacketDescendingChaos;
import auviotre.enigmatic.addon.packets.clients.PacketDisasterParry;
import auviotre.enigmatic.addon.packets.clients.PacketEvilCage;
import auviotre.enigmatic.addon.packets.clients.PacketMaliceTotem;
import auviotre.enigmatic.addon.packets.clients.PacketStarParticles;
import auviotre.enigmatic.addon.packets.server.PacketCursedXPScrollKey;
import auviotre.enigmatic.addon.packets.server.PacketEmptyLeftClick;
import auviotre.enigmatic.addon.proxy.ClientProxy;
import auviotre.enigmatic.addon.proxy.CommonProxy;
import auviotre.enigmatic.addon.registries.AbstractRegistry;
import auviotre.enigmatic.addon.registries.EnigmaticAddonBlocks;
import auviotre.enigmatic.addon.registries.EnigmaticAddonDamageTypes;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEffects;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEnchantments;
import auviotre.enigmatic.addon.registries.EnigmaticAddonEntities;
import auviotre.enigmatic.addon.registries.EnigmaticAddonItems;
import auviotre.enigmatic.addon.registries.EnigmaticAddonLootModifier;
import auviotre.enigmatic.addon.registries.EnigmaticAddonMenus;
import auviotre.enigmatic.addon.registries.EnigmaticAddonParticles;
import auviotre.enigmatic.addon.registries.EnigmaticAddonPotions;
import auviotre.enigmatic.addon.registries.EnigmaticAddonRecipes;
import auviotre.enigmatic.addon.registries.FutureItems;
import auviotre.enigmatic.addon.triggers.BlessRingEquippedTrigger;
import com.aizistral.enigmaticlegacy.brewing.ValidationBrewingRecipe;
import com.aizistral.enigmaticlegacy.objects.LoggerWrapper;
import com.aizistral.enigmaticlegacy.registries.EnigmaticBlocks;
import com.aizistral.enigmaticlegacy.registries.EnigmaticItems;
import com.aizistral.enigmaticlegacy.registries.EnigmaticTabs;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.common.util.MutableHashedLinkedMap;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

@Mod(value="enigmaticaddons")
public class EnigmaticAddons {
    public static final String MODID = "enigmaticaddons";
    public static final LoggerWrapper LOGGER = new LoggerWrapper("Enigmatic Addons");
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.unsafeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    public static SimpleChannel packetInstance;

    public EnigmaticAddons() {
        LOGGER.info("Constructing mod instance...");
        OmniconfigAddonHandler.initialize();
        AbstractRegistry.loadClass(EnigmaticAddonItems.class);
        AbstractRegistry.loadClass(EnigmaticAddonMenus.class);
        AbstractRegistry.loadClass(EnigmaticAddonBlocks.class);
        AbstractRegistry.loadClass(EnigmaticAddonEffects.class);
        AbstractRegistry.loadClass(EnigmaticAddonRecipes.class);
        AbstractRegistry.loadClass(EnigmaticAddonEntities.class);
        AbstractRegistry.loadClass(EnigmaticAddonParticles.class);
        AbstractRegistry.loadClass(EnigmaticAddonEnchantments.class);
        AbstractRegistry.loadClass(EnigmaticAddonLootModifier.class);
        if (OmniconfigAddonHandler.FutureItemDisplay.getValue()) {
            AbstractRegistry.loadClass(FutureItems.class);
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientRegistries);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onLoadComplete);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)this);
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)PROXY);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        MinecraftForge.EVENT_BUS.register((Object)new AddonEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new AddonKeybindHandler());
        MinecraftForge.EVENT_BUS.addListener(this::onServerStart);
        LOGGER.info("Mod instance constructed successfully.");
    }

    private void setup(FMLCommonSetupEvent event) {
        LOGGER.info("Initializing common setup phase...");
        PROXY.commonInit();
        event.enqueueWork(() -> AbstractRegistry.loadClass(EnigmaticAddonDamageTypes.class));
        event.enqueueWork(() -> AbstractRegistry.loadClass(EnigmaticAddonPotions.class));
        LOGGER.info("Registering packets...");
        packetInstance = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation(MODID, "main")).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();
        packetInstance.registerMessage(0, PacketCursedXPScrollKey.class, PacketCursedXPScrollKey::encode, PacketCursedXPScrollKey::decode, PacketCursedXPScrollKey::handle);
        packetInstance.registerMessage(1, PacketEmptyLeftClick.class, PacketEmptyLeftClick::encode, PacketEmptyLeftClick::decode, PacketEmptyLeftClick::handle);
        packetInstance.registerMessage(2, PacketStarParticles.class, PacketStarParticles::encode, PacketStarParticles::decode, PacketStarParticles::handle);
        packetInstance.registerMessage(3, PacketEvilCage.class, PacketEvilCage::encode, PacketEvilCage::decode, PacketEvilCage::handle);
        packetInstance.registerMessage(4, PacketDisasterParry.class, PacketDisasterParry::encode, PacketDisasterParry::decode, PacketDisasterParry::handle);
        packetInstance.registerMessage(5, PacketMaliceTotem.class, PacketMaliceTotem::encode, PacketMaliceTotem::decode, PacketMaliceTotem::handle);
        packetInstance.registerMessage(6, PacketDescendingChaos.class, PacketDescendingChaos::encode, PacketDescendingChaos::decode, PacketDescendingChaos::handle);
        LOGGER.info("Common setup phase finished successfully.");
    }

    public void onLoadComplete(FMLLoadCompleteEvent event) {
        LOGGER.info("Initializing load completion phase...");
        EnigmaticItems.SPELLSTONES.add(EnigmaticAddonItems.FORGOTTEN_ICE);
        EnigmaticItems.SPELLSTONES.add(EnigmaticAddonItems.REVIVAL_LEAF);
        EnigmaticItems.SPELLSTONES.add(EnigmaticAddonItems.LOST_ENGINE);
        EnigmaticItems.SPELLSTONES.add(EnigmaticAddonItems.ETHERIUM_CORE);
        LOGGER.info("Registering brewing recipes...");
        if (OmniconfigAddonHandler.isItemEnabled((Object)EnigmaticAddonItems.COMMON_POTION)) {
            PotionAddonHelper.registerCommonPotions();
        }
        if (OmniconfigAddonHandler.isItemEnabled((Object)EnigmaticAddonItems.ULTIMATE_POTION)) {
            PotionAddonHelper.registerUltimatePotions();
        }
        if (OmniconfigAddonHandler.isItemEnabled((Object)EnigmaticAddonItems.ASTRAL_POTION)) {
            BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new AstralBrewingRecipe(new ResourceLocation(MODID, "astral_potion")));
        }
        PotionAddonHelper.registerDispenserBehavior();
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new ValidationBrewingRecipe(PotionAddonHelper.SPECIAL_POTIONS, null));
        LOGGER.info("Registering triggers...");
        CriteriaTriggers.m_10595_((CriterionTrigger)BlessRingEquippedTrigger.INSTANCE);
        LOGGER.info("Load completion phase finished successfully");
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        LOGGER.info("Initializing client setup phase...");
        PROXY.clientInit();
        LOGGER.info("Client setup phase finished successfully.");
    }

    private void onServerStart(ServerAboutToStartEvent event) {
        this.performCleanup();
    }

    public void performCleanup() {
        AddonEventHandler.NIGHT_SCROLL_BOXES.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void buildCreativeModeTabContents(@NotNull BuildCreativeModeTabContentsEvent event) {
        MutableHashedLinkedMap entries = event.getEntries();
        if (event.getTab() == EnigmaticTabs.MAIN && OmniconfigAddonHandler.TabResorted.getValue()) {
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ENIGMATIC_ITEM, (ItemLike)EnigmaticItems.THE_ACKNOWLEDGMENT);
            entries.putAfter((Object)((ItemStack)EnigmaticItems.ENIGMATIC_AMULET.getCreativeTabStacks().get(6)), (Object)new ItemStack((ItemLike)EnigmaticItems.IRON_RING), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.IRON_RING, (ItemLike)EnigmaticItems.GOLDEN_RING);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.GOLDEN_RING, (ItemLike)EnigmaticItems.ENDER_RING);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ENDER_RING, (ItemLike)EnigmaticAddonItems.QUARTZ_RING);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.QUARTZ_RING, (ItemLike)EnigmaticItems.MAGNET_RING);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.MAGNET_RING, (ItemLike)EnigmaticItems.SUPER_MAGNET_RING);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.SUPER_MAGNET_RING, (ItemLike)EnigmaticItems.ANIMAL_GUIDEBOOK);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ANIMAL_GUIDEBOOK, (ItemLike)EnigmaticItems.HUNTER_GUIDEBOOK);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.HUNTER_GUIDEBOOK, (ItemLike)EnigmaticAddonItems.LIVING_ODE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.LIVING_ODE, (ItemLike)EnigmaticItems.ENIGMATIC_EYE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ENIGMATIC_EYE, (ItemLike)EnigmaticItems.TATTERED_TOME);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.TATTERED_TOME, (ItemLike)EnigmaticItems.WITHERED_TOME);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.WITHERED_TOME, (ItemLike)EnigmaticItems.CORRUPTED_TOME);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.CORRUPTED_TOME, (ItemLike)EnigmaticItems.THICC_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.THICC_SCROLL, (ItemLike)EnigmaticItems.XP_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.XP_SCROLL, (ItemLike)EnigmaticItems.ESCAPE_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ESCAPE_SCROLL, (ItemLike)EnigmaticItems.HEAVEN_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.HEAVEN_SCROLL, (ItemLike)EnigmaticItems.FABULOUS_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.FABULOUS_SCROLL, (ItemLike)EnigmaticItems.EARTH_HEART);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.EARTH_HEART, (ItemLike)EnigmaticAddonItems.EARTH_HEART_FRAGMENT);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.EARTH_HEART_FRAGMENT, (ItemLike)EnigmaticItems.EXTRADIMENSIONAL_EYE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.EXTRADIMENSIONAL_EYE, (ItemLike)EnigmaticItems.MINING_CHARM);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.MINING_CHARM, (ItemLike)EnigmaticItems.MONSTER_CHARM);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.MONSTER_CHARM, (ItemLike)EnigmaticAddonItems.ADVENTURE_CHARM);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.ADVENTURE_CHARM, (ItemLike)EnigmaticItems.ENCHANTMENT_TRANSPOSER);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ENCHANTMENT_TRANSPOSER, (ItemLike)EnigmaticItems.INFINIMEAL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.INFINIMEAL, (ItemLike)EnigmaticItems.RECALL_POTION);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ANGEL_BLESSING, (ItemLike)EnigmaticAddonItems.FORGOTTEN_ICE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.FORGOTTEN_ICE, (ItemLike)EnigmaticAddonItems.REVIVAL_LEAF);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.REVIVAL_LEAF, (ItemLike)EnigmaticAddonItems.LOST_ENGINE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.LOST_ENGINE, (ItemLike)EnigmaticItems.LORE_INSCRIBER);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.LORE_INSCRIBER, (ItemLike)EnigmaticItems.LORE_FRAGMENT);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.LORE_FRAGMENT, (ItemLike)EnigmaticItems.VOID_STONE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.VOID_STONE, (ItemLike)EnigmaticItems.UNHOLY_GRAIL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.UNHOLY_GRAIL, (ItemLike)EnigmaticAddonItems.ANTIQUE_BAG);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.ANTIQUE_BAG, (ItemLike)EnigmaticAddonItems.VOID_TOME);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.VOID_TOME, (ItemLike)EnigmaticAddonItems.FORGER_GEM);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.FORGER_GEM, (ItemLike)EnigmaticAddonItems.HELL_BLADE_CHARM);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.HELL_BLADE_CHARM, (ItemLike)EnigmaticItems.MEGA_SPONGE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.MEGA_SPONGE, (ItemLike)EnigmaticItems.FORBIDDEN_AXE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.FORBIDDEN_AXE, (ItemLike)EnigmaticAddonItems.DISASTER_SWORD);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.DISASTER_SWORD, (ItemLike)EnigmaticAddonItems.ICHOR_DROPLET);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.ICHOR_DROPLET, (ItemLike)EnigmaticAddonItems.ICHOROOT);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.ICHOROOT, (ItemLike)EnigmaticAddonItems.ICHOR_SPEAR);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.ICHOR_SPEAR, (ItemLike)EnigmaticItems.ASTRAL_DUST);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ASTRAL_DUST, (ItemLike)EnigmaticBlocks.ASTRAL_BLOCK);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.ASTRAL_BLOCK, (ItemLike)EnigmaticItems.ENDER_ROD);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ENDER_ROD, (ItemLike)EnigmaticItems.MENDING_MIXTURE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.MENDING_MIXTURE, (ItemLike)EnigmaticItems.ASTRAL_POTATO);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ASTRAL_POTATO, (ItemLike)EnigmaticAddonItems.ASTRAL_POTION);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.ASTRAL_POTION, (ItemLike)EnigmaticAddonItems.DRAGON_BOW);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.DRAGON_BOW, (ItemLike)EnigmaticItems.COSMIC_HEART);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.COSMIC_HEART, (ItemLike)EnigmaticItems.INSIGNIA);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.INSIGNIA, (ItemLike)EnigmaticBlocks.COSMIC_CAKE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.COSMIC_CAKE, (ItemLike)EnigmaticItems.UNWITNESSED_AMULET);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.UNWITNESSED_AMULET, (ItemLike)EnigmaticItems.ASCENSION_AMULET);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ASCENSION_AMULET, (ItemLike)EnigmaticItems.ICHOR_BOTTLE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ICHOR_BOTTLE, (ItemLike)EnigmaticItems.FORBIDDEN_FRUIT);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.FORBIDDEN_FRUIT, (ItemLike)EnigmaticAddonItems.PRIMEVAL_CUBE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.PRIMEVAL_CUBE, (ItemLike)EnigmaticItems.THE_CUBE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.THE_CUBE, (ItemLike)EnigmaticBlocks.BIG_LAMP);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.BIG_LAMP, (ItemLike)EnigmaticBlocks.MASSIVE_LAMP);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.MASSIVE_LAMP, (ItemLike)EnigmaticBlocks.BIG_REDSTONELAMP);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.BIG_REDSTONELAMP, (ItemLike)EnigmaticBlocks.MASSIVE_REDSTONELAMP);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.MASSIVE_REDSTONELAMP, (ItemLike)EnigmaticBlocks.BIG_SHROOMLAMP);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.BIG_SHROOMLAMP, (ItemLike)EnigmaticBlocks.MASSIVE_SHROOMLAMP);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ETHERIUM_NUGGET, (ItemLike)EnigmaticBlocks.ETHERIUM_BLOCK);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ASTRAL_BREAKER, (ItemLike)EnigmaticAddonItems.ASTRAL_SPEAR);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.ASTRAL_SPEAR, (ItemLike)EnigmaticBlocks.END_ANCHOR);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.END_ANCHOR, (ItemLike)EnigmaticItems.ENIGMATIC_ELYTRA);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ENIGMATIC_ELYTRA, (ItemLike)EnigmaticAddonItems.ETHERIUM_CORE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.ETHERIUM_CORE, (ItemLike)EnigmaticItems.CURSED_RING);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.CURSED_RING, (ItemLike)EnigmaticItems.TWISTED_HEART);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.TWISTED_HEART, (ItemLike)EnigmaticItems.TWISTED_POTION);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.TWISTED_POTION, (ItemLike)EnigmaticItems.TWISTED_MIRROR);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.TWISTED_MIRROR, (ItemLike)EnigmaticItems.SOUL_COMPASS);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.SOUL_COMPASS, (ItemLike)EnigmaticItems.BERSERK_CHARM);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.BERSERK_CHARM, (ItemLike)EnigmaticItems.INFERNAL_SHIELD);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.INFERNAL_SHIELD, (ItemLike)EnigmaticItems.ENCHANTER_PEARL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ENCHANTER_PEARL, (ItemLike)EnigmaticItems.ASTRAL_FRUIT);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ASTRAL_FRUIT, (ItemLike)EnigmaticItems.GUARDIAN_HEART);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.GUARDIAN_HEART, (ItemLike)EnigmaticItems.EVIL_ESSENCE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.EVIL_ESSENCE, (ItemLike)EnigmaticItems.EVIL_INGOT);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.EVIL_INGOT, (ItemLike)EnigmaticAddonItems.EVIL_DAGGER);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.EVIL_DAGGER, (ItemLike)EnigmaticItems.THE_TWIST);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.THE_TWIST, (ItemLike)EnigmaticItems.ENDER_SLAYER);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ENDER_SLAYER, (ItemLike)EnigmaticAddonItems.TOTEM_OF_MALICE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.TOTEM_OF_MALICE, (ItemLike)EnigmaticItems.CURSE_TRANSPOSER);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.CURSE_TRANSPOSER, (ItemLike)EnigmaticAddonItems.SANGUINARY_HANDBOOK);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.SANGUINARY_HANDBOOK, (ItemLike)EnigmaticAddonItems.FALSE_JUSTICE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.FALSE_JUSTICE, (ItemLike)EnigmaticItems.CURSED_STONE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.CURSED_STONE, (ItemLike)EnigmaticAddonItems.PURE_HEART);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.PURE_HEART, (ItemLike)EnigmaticAddonItems.THE_BLESS);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.THE_BLESS, (ItemLike)EnigmaticAddonItems.BLESS_AMPLIFIER);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.BLESS_AMPLIFIER, (ItemLike)EnigmaticAddonItems.SCORCHED_CHARM);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.SCORCHED_CHARM, (ItemLike)EnigmaticAddonItems.EARTH_PROMISE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.EARTH_PROMISE, (ItemLike)EnigmaticAddonItems.BLESS_STONE);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.BLESS_STONE, (ItemLike)EnigmaticAddonItems.BLESS_RING);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.BLESS_RING, (ItemLike)EnigmaticItems.DARKEST_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.DARKEST_SCROLL, (ItemLike)EnigmaticAddonItems.CURSED_XP_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.CURSED_XP_SCROLL, (ItemLike)EnigmaticAddonItems.NIGHT_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.NIGHT_SCROLL, (ItemLike)EnigmaticItems.AVARICE_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.AVARICE_SCROLL, (ItemLike)EnigmaticItems.CURSED_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.CURSED_SCROLL, (ItemLike)EnigmaticAddonItems.THUNDER_SCROLL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.THUNDER_SCROLL, (ItemLike)EnigmaticItems.ABYSSAL_HEART);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ABYSSAL_HEART, (ItemLike)EnigmaticItems.THE_INFINITUM);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.THE_INFINITUM, (ItemLike)EnigmaticItems.DESOLATION_RING);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.DESOLATION_RING, (ItemLike)EnigmaticItems.ELDRITCH_AMULET);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ELDRITCH_AMULET, (ItemLike)EnigmaticAddonItems.CHAOS_ELYTRA);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticAddonItems.CHAOS_ELYTRA, (ItemLike)EnigmaticItems.ELDRITCH_PAN);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ELDRITCH_PAN, (ItemLike)EnigmaticItems.LOOT_GENERATOR);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.LOOT_GENERATOR, (ItemLike)EnigmaticItems.REDEMPTION_POTION);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.REDEMPTION_POTION, (ItemLike)EnigmaticItems.SOUL_CRYSTAL);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.SOUL_CRYSTAL, (ItemLike)EnigmaticItems.QUOTE_PLAYER);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.QUOTE_PLAYER, (ItemLike)EnigmaticItems.DECEPTION_AMULET);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.DECEPTION_AMULET, (ItemLike)EnigmaticItems.ETHERIUM_SCRAPS);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.ETHERIUM_SCRAPS, (ItemLike)EnigmaticItems.SOUL_DUST);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.SOUL_DUST, (ItemLike)EnigmaticItems.THE_JUDGEMENT);
            this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticItems.THE_JUDGEMENT, (ItemLike)EnigmaticBlocks.STAR_FABRIC);
            if (OmniconfigAddonHandler.FutureItemDisplay.getValue()) {
                this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)EnigmaticBlocks.STAR_FABRIC, (ItemLike)FutureItems.DARK_HELMET);
                this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)FutureItems.DARK_HELMET, (ItemLike)FutureItems.DARK_CHESTPLATE);
                this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)FutureItems.DARK_CHESTPLATE, (ItemLike)FutureItems.DARK_LEGGINGS);
                this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)FutureItems.DARK_LEGGINGS, (ItemLike)FutureItems.DARK_BOOTS);
                this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)FutureItems.DARK_BOOTS, (ItemLike)FutureItems.LIVING_FLAME);
                this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)FutureItems.LIVING_FLAME, (ItemLike)FutureItems.WORMHOLE_POTION);
                this.putAfter((MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility>)entries, (ItemLike)FutureItems.WORMHOLE_POTION, (ItemLike)FutureItems.GEM_OF_BINDING);
            }
        }
    }

    private void putAfter(MutableHashedLinkedMap<ItemStack, CreativeModeTab.TabVisibility> entries, ItemLike after, ItemLike item) {
        entries.putAfter((Object)new ItemStack(after), (Object)new ItemStack(item), (Object)CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
    }

    @SubscribeEvent
    public void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            IModFileInfo modFileInfo = ModList.get().getModFileById(MODID);
            if (modFileInfo == null) {
                return;
            }
            String builtin = "no_3d_models";
            IModFile modFile = modFileInfo.getFile();
            event.addRepositorySource(consumer -> {
                Pack pack = Pack.m_245429_((String)("enigmaticaddons:" + builtin), (Component)Component.m_237113_((String)"No 3D Models"), (boolean)false, id -> new FilePackResources(id, modFile, "resourcepacks/" + builtin), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                if (pack != null) {
                    consumer.accept(pack);
                }
            });
        }
    }
}

