/*
 * Decompiled with CFR 0.152.
 */
package com.texelsaurus.minecraft.chameleon.service;

import com.texelsaurus.minecraft.chameleon.capabilities.ChameleonCapability;
import com.texelsaurus.minecraft.chameleon.capabilities.FabricCapability;
import com.texelsaurus.minecraft.chameleon.capabilities.IFabricCapability;
import com.texelsaurus.minecraft.chameleon.service.ChameleonCapabilities;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;

public class FabricCapabilities
implements ChameleonCapabilities {
    private static Map<class_2960, IFabricCapability> capabilties = new HashMap<class_2960, IFabricCapability>();

    @Override
    public <T, C> ChameleonCapability<T> create(class_2960 location, Class<T> clazz, Class<C> context) {
        return new DeferredCapability(location);
    }

    public static <T> void reigsterCapability(FabricCapability<T> capability) {
        capabilties.put(capability.id(), capability);
    }

    private class DeferredCapability<T>
    implements IFabricCapability<T> {
        private class_2960 id;
        private IFabricCapability<T> cap;

        public DeferredCapability(class_2960 id) {
            this.id = id;
        }

        @Override
        public class_2960 id() {
            return this.id;
        }

        @Override
        public T getCapability(class_1937 level, class_2338 pos) {
            if (this.cap != null) {
                return this.cap.getCapability(level, pos);
            }
            this.cap = capabilties.getOrDefault(this.id, null);
            if (this.cap != null) {
                return this.cap.getCapability(level, pos);
            }
            return null;
        }

        @Override
        public <BE extends class_2586> T getCapability(BE blockEntity) {
            if (this.cap != null) {
                return this.cap.getCapability(blockEntity);
            }
            this.cap = capabilties.getOrDefault(this.id, null);
            if (this.cap != null) {
                return this.cap.getCapability(blockEntity);
            }
            return null;
        }

        @Override
        public <BE extends class_2586> void register(class_2591<BE> entity, Function<BE, T> provider) {
            if (this.cap == null) {
                this.cap = capabilties.getOrDefault(this.id, null);
            }
            if (this.cap != null) {
                this.cap.register(entity, provider);
            }
        }
    }
}

