/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.google.common.collect.MapMaker;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.inventory.DrawerStackStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.SlottedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import org.jetbrains.annotations.UnmodifiableView;

public class DrawerStorageImpl
extends CombinedStorage<ItemVariant, SingleSlotStorage<ItemVariant>>
implements SlottedStorage<ItemVariant> {
    private static final Map<IDrawerGroup, DrawerStorageImpl> WRAPPERS = new MapMaker().weakValues().makeMap();
    final IDrawerGroup group;
    final List<DrawerStackStorage> backingList;

    public static DrawerStorageImpl of(IDrawerGroup group) {
        DrawerStorageImpl storage = WRAPPERS.computeIfAbsent(group, DrawerStorageImpl::new);
        storage.resizeSlotList();
        return storage;
    }

    public DrawerStorageImpl(IDrawerGroup group) {
        super(Collections.emptyList());
        this.group = group;
        this.backingList = new ArrayList<DrawerStackStorage>();
    }

    public @UnmodifiableView List<SingleSlotStorage<ItemVariant>> getSlots() {
        return this.parts;
    }

    private void resizeSlotList() {
        int[] slots = this.group.getAccessibleDrawerSlots();
        if (slots.length != this.parts.size()) {
            while (this.backingList.size() < slots.length) {
                this.backingList.add(new DrawerStackStorage(this, this.backingList.size()));
            }
            this.parts = Collections.unmodifiableList(this.backingList.subList(0, slots.length));
        }
        for (int i = 0; i < slots.length; ++i) {
            this.backingList.get(i).updateSlot(slots[i]);
        }
    }

    public int getSlotCount() {
        return this.getSlots().size();
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return this.getSlots().get(slot);
    }

    IDrawer getDrawer(int slot) {
        if (slot < 0 || slot >= this.group.getDrawerCount()) {
            return Drawers.DISABLED;
        }
        return this.group.getDrawer(slot);
    }
}

