/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object.entity.pathfinding.raycoms;

import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AbstractAdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IStuckHandler;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.SurfaceType;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.BiPredicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_9;

public class PathingStuckHandler
implements IStuckHandler {
    private static final double MIN_TARGET_DIST = 3.0;
    private static final int MIN_TP_DELAY = 2400;
    private static final int MIN_DIST_FOR_TP = 10;
    private final List<class_2350> directions = Arrays.asList(class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039);
    private final Random rand = new Random();
    private int teleportRange = 0;
    private int timePerBlockDistance = 100;
    private int stuckLevel = 0;
    private int globalTimeout = 0;
    private class_2338 prevDestination = class_2338.field_10980;
    private boolean canBreakBlocks = false;
    private boolean canPlaceLadders = false;
    private boolean canBuildLeafBridges = false;
    private boolean canTeleportGoal = false;
    private boolean takeDamageOnCompleteStuck = false;
    private float damagePct = 0.2f;
    private int completeStuckBlockBreakRange = 0;
    private boolean hadPath = false;
    private int lastPathIndex = -1;
    private int progressedNodes = 0;
    private int delayBeforeActions;
    private int delayToNextUnstuckAction = this.delayBeforeActions = 1200;
    private class_2338 moveAwayStartPos = class_2338.field_10980;

    private PathingStuckHandler() {
    }

    public static PathingStuckHandler createStuckHandler() {
        return new PathingStuckHandler();
    }

    public static class_2350 getFacing(class_2338 pos, class_2338 neighbor) {
        class_2338 vector = neighbor.method_10059((class_2382)pos);
        return class_2350.method_10147((float)vector.method_10263(), (float)vector.method_10264(), (float)(-vector.method_10260()));
    }

    public static class_2338 findAround(class_1937 world, class_2338 start, int vRange, int hRange, BiPredicate<class_1922, class_2338> predicate) {
        if (vRange < 1 && hRange < 1) {
            return null;
        }
        if (predicate.test((class_1922)world, start)) {
            return start;
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < hRange + 2; ++i) {
            for (int steps = 1; steps <= vRange; ++steps) {
                int z;
                int x;
                class_2338 temp = start.method_10069(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((class_1922)world, temp = temp.method_10069(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((class_1922)world, temp = temp.method_10069(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((class_1922)world, temp = temp.method_10069(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((class_1922)world, temp = temp.method_10069(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (world.method_31600() > start.method_10264() + (y += (y_offset *= -1))) continue;
            return null;
        }
        return null;
    }

    @Override
    public void checkStuck(AbstractAdvancedPathNavigate navigator) {
        if (navigator.getDesiredPos() == null || navigator.getDesiredPos().equals((Object)class_2338.field_10980)) {
            return;
        }
        double distanceToGoal = navigator.getOurEntity().method_19538().method_1022(new class_243((double)navigator.getDesiredPos().method_10263(), (double)navigator.getDesiredPos().method_10264(), (double)navigator.getDesiredPos().method_10260()));
        if (distanceToGoal < 3.0) {
            this.resetGlobalStuckTimers();
            return;
        }
        if (this.prevDestination.equals((Object)navigator.getDesiredPos())) {
            ++this.globalTimeout;
            if ((double)this.globalTimeout > Math.max(2400.0, (double)this.timePerBlockDistance * Math.max(10.0, distanceToGoal))) {
                this.completeStuckAction(navigator);
            }
        } else {
            this.resetGlobalStuckTimers();
        }
        this.prevDestination = navigator.getDesiredPos();
        if (navigator.method_6345() == null || navigator.method_6345().method_46()) {
            this.lastPathIndex = -1;
            this.progressedNodes = 0;
            if (!this.hadPath) {
                this.tryUnstuck(navigator);
            }
        } else if (navigator.method_6345().method_39() == this.lastPathIndex) {
            this.tryUnstuck(navigator);
        } else if (this.lastPathIndex != -1 && navigator.method_6345().method_48().method_10262((class_2382)this.prevDestination) < 25.0) {
            int n = this.progressedNodes = navigator.method_6345().method_39() > this.lastPathIndex ? this.progressedNodes + 1 : this.progressedNodes - 1;
            if (!(this.progressedNodes <= 5 || navigator.method_6345().method_45() != null && this.moveAwayStartPos.equals((Object)navigator.method_6345().method_45().method_22879()))) {
                this.resetStuckTimers();
            }
        }
        this.lastPathIndex = navigator.method_6345() != null ? navigator.method_6345().method_39() : -1;
        this.hadPath = navigator.method_6345() != null && !navigator.method_6345().method_46();
    }

    private void resetGlobalStuckTimers() {
        this.globalTimeout = 0;
        this.prevDestination = class_2338.field_10980;
        this.resetStuckTimers();
    }

    private void completeStuckAction(AbstractAdvancedPathNavigate navigator) {
        class_2338 tpPos;
        class_2338 desired = navigator.getDesiredPos();
        class_1937 world = navigator.getOurEntity().method_37908();
        class_1308 entity = navigator.getOurEntity();
        if (this.canTeleportGoal && (tpPos = PathingStuckHandler.findAround(world, desired, 10, 10, (posworld, pos) -> SurfaceType.getSurfaceType(posworld, posworld.method_8320(pos.method_10074()), pos.method_10074()) == SurfaceType.WALKABLE && SurfaceType.getSurfaceType(posworld, posworld.method_8320(pos), pos) == SurfaceType.DROPABLE && SurfaceType.getSurfaceType(posworld, posworld.method_8320(pos.method_10084()), pos.method_10084()) == SurfaceType.DROPABLE)) != null) {
            entity.method_5859((double)tpPos.method_10263() + 0.5, (double)tpPos.method_10264(), (double)tpPos.method_10260() + 0.5);
        }
        if (this.takeDamageOnCompleteStuck) {
            entity.method_5643(new class_1282(entity.method_37908().method_48963().method_48822().method_48793(), (class_1297)entity), entity.method_6063() * this.damagePct);
        }
        if (this.completeStuckBlockBreakRange > 0) {
            class_2350 facing = PathingStuckHandler.getFacing(entity.method_24515(), navigator.getDesiredPos());
            for (int i = 1; i <= this.completeStuckBlockBreakRange; ++i) {
                if (world.method_22347(new class_2338((class_2382)entity.method_24515()).method_10079(facing, i)) && world.method_22347(new class_2338((class_2382)entity.method_24515()).method_10079(facing, i).method_10084())) continue;
                this.breakBlocksAhead(world, new class_2338((class_2382)entity.method_24515()).method_10079(facing, i - 1), facing);
                break;
            }
        }
        navigator.method_6340();
        this.resetGlobalStuckTimers();
    }

    private void tryUnstuck(AbstractAdvancedPathNavigate navigator) {
        if (this.delayToNextUnstuckAction-- > 0) {
            return;
        }
        this.delayToNextUnstuckAction = 50;
        if (this.stuckLevel == 0) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 100;
            navigator.method_6340();
            return;
        }
        if (this.stuckLevel == 1) {
            ++this.stuckLevel;
            this.delayToNextUnstuckAction = 200;
            navigator.method_6340();
            navigator.moveAwayFromXYZ(new class_2338((class_2382)navigator.getOurEntity().method_24515()), 10.0, 1.0, false);
            navigator.getPathingOptions().setCanClimb(false);
            this.moveAwayStartPos = navigator.getOurEntity().method_24515();
            return;
        }
        if (this.stuckLevel == 2 && this.teleportRange > 0 && this.hadPath) {
            assert (navigator.method_6345() != null);
            int index = Math.min(navigator.method_6345().method_39() + this.teleportRange, navigator.method_6345().method_38() - 1);
            class_9 togo = navigator.method_6345().method_40(index);
            navigator.getOurEntity().method_5859((double)togo.field_40 + 0.5, (double)togo.field_39, (double)togo.field_38 + 0.5);
            this.delayToNextUnstuckAction = 300;
        }
        if (this.stuckLevel >= 3 && this.stuckLevel <= 5) {
            if (this.canPlaceLadders && this.rand.nextBoolean()) {
                this.delayToNextUnstuckAction = 200;
                this.placeLadders(navigator);
            } else if (this.canBuildLeafBridges && this.rand.nextBoolean()) {
                this.delayToNextUnstuckAction = 100;
                this.placeLeaves(navigator);
            }
        }
        if (this.stuckLevel >= 6 && this.stuckLevel <= 8 && this.canBreakBlocks) {
            this.delayToNextUnstuckAction = 200;
            this.breakBlocks(navigator);
        }
        this.chanceStuckLevel();
        if (this.stuckLevel == 9) {
            this.completeStuckAction(navigator);
            this.resetStuckTimers();
        }
    }

    private void chanceStuckLevel() {
        ++this.stuckLevel;
        if (this.stuckLevel > 1 && this.rand.nextInt(6) == 0) {
            this.stuckLevel -= 2;
        }
    }

    private void resetStuckTimers() {
        this.delayToNextUnstuckAction = this.delayBeforeActions;
        this.lastPathIndex = -1;
        this.progressedNodes = 0;
        this.stuckLevel = 0;
        this.moveAwayStartPos = class_2338.field_10980;
    }

    private void breakBlocksAhead(class_1937 world, class_2338 start, class_2350 facing) {
        if (!world.method_22347(start.method_10086(3))) {
            this.setAirIfPossible(world, start.method_10086(3));
            return;
        }
        if (!world.method_22347(start.method_10084().method_10093(facing))) {
            this.setAirIfPossible(world, start.method_10084().method_10093(facing));
            return;
        }
        if (!world.method_22347(start.method_10093(facing))) {
            this.setAirIfPossible(world, start.method_10093(facing));
        }
    }

    private void setAirIfPossible(class_1937 world, class_2338 pos) {
        world.method_8501(pos, class_2246.field_10124.method_9564());
    }

    private void placeLadders(AbstractAdvancedPathNavigate navigator) {
        class_1937 world = navigator.getOurEntity().method_37908();
        class_1308 entity = navigator.getOurEntity();
        class_2338 entityPos = entity.method_24515();
        while (world.method_8320(entityPos).method_26204() == class_2246.field_9983) {
            entityPos = entityPos.method_10084();
        }
        this.tryPlaceLadderAt(world, entityPos);
        this.tryPlaceLadderAt(world, entityPos.method_10084());
        this.tryPlaceLadderAt(world, entityPos.method_10086(2));
    }

    private void placeLeaves(AbstractAdvancedPathNavigate navigator) {
        class_1937 world = navigator.getOurEntity().method_37908();
        class_1308 entity = navigator.getOurEntity();
        class_2350 badFacing = PathingStuckHandler.getFacing(entity.method_24515(), navigator.getDesiredPos()).method_10153();
        for (class_2350 dir : this.directions) {
            if (dir == badFacing || !world.method_22347(entity.method_24515().method_10074().method_10093(dir))) continue;
            world.method_8501(entity.method_24515().method_10074().method_10093(dir), class_2246.field_10098.method_9564());
        }
    }

    private void breakBlocks(AbstractAdvancedPathNavigate navigator) {
        class_1937 world = navigator.getOurEntity().method_37908();
        class_1308 entity = navigator.getOurEntity();
        class_2350 facing = PathingStuckHandler.getFacing(entity.method_24515(), navigator.getDesiredPos());
        this.breakBlocksAhead(world, entity.method_24515(), facing);
    }

    private void tryPlaceLadderAt(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_26204() != class_2246.field_9983 && !state.method_26225() && world.method_8316(pos).method_15769()) {
            for (class_2350 dir : this.directions) {
                class_2680 toPlace = (class_2680)class_2246.field_9983.method_9564().method_11657((class_2769)class_2399.field_11253, (Comparable)dir.method_10153());
                if (!world.method_8320(pos.method_10093(dir)).method_51367() || !class_2246.field_9983.method_9558(toPlace, (class_4538)world, pos)) continue;
                world.method_8501(pos, toPlace);
                break;
            }
        }
    }

    public PathingStuckHandler withBlockBreaks() {
        this.canBreakBlocks = true;
        return this;
    }

    public PathingStuckHandler withPlaceLadders() {
        this.canPlaceLadders = true;
        return this;
    }

    public PathingStuckHandler withBuildLeafBridges() {
        this.canBuildLeafBridges = true;
        return this;
    }

    public PathingStuckHandler withTeleportSteps(int steps) {
        this.teleportRange = steps;
        return this;
    }

    public PathingStuckHandler withTeleportOnFullStuck() {
        this.canTeleportGoal = true;
        return this;
    }

    public PathingStuckHandler withTakeDamageOnStuck(float damagePct) {
        this.damagePct = damagePct;
        this.takeDamageOnCompleteStuck = true;
        return this;
    }

    public PathingStuckHandler withTimePerBlockDistance(int time) {
        this.timePerBlockDistance = time;
        return this;
    }

    public PathingStuckHandler withDelayBeforeStuckActions(int delay) {
        this.delayBeforeActions = delay;
        return this;
    }

    public PathingStuckHandler withCompleteStuckBlockBreak(int range) {
        this.completeStuckBlockBreakRange = range;
        return this;
    }
}

