/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.common.recipe.ingredient.fabric;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.networking.PacketHelper;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.CodecIngredient;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.CodecIngredientSerializer;
import com.teamresourceful.resourcefullib.common.recipe.ingredient.fabric.FabricIngredient;
import java.util.Map;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class FabricIngredientSerializer<T extends CodecIngredient<T>>
implements CustomIngredientSerializer<FabricIngredient<T>> {
    private final CodecIngredientSerializer<T> serializer;

    public FabricIngredientSerializer(CodecIngredientSerializer<T> serializer) {
        this.serializer = serializer;
    }

    public class_2960 getIdentifier() {
        return this.serializer.id();
    }

    public FabricIngredient<T> read(JsonObject json) {
        CodecIngredient ingredient = (CodecIngredient)this.serializer.codec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)Constants.LOGGER).error(arg_0));
        return new FabricIngredient<CodecIngredient>(ingredient);
    }

    public void write(JsonObject json, FabricIngredient<T> ingredient) {
        JsonElement element = (JsonElement)this.serializer.codec().encodeStart((DynamicOps)JsonOps.INSTANCE, ingredient.ingredient()).getOrThrow(false, arg_0 -> ((Logger)Constants.LOGGER).error(arg_0));
        if (!element.isJsonObject()) {
            Constants.LOGGER.error("Could not parse {}", ingredient.ingredient());
            Constants.LOGGER.error("Element is not a JsonObject");
            return;
        }
        for (Map.Entry entry : element.getAsJsonObject().entrySet()) {
            json.add((String)entry.getKey(), (JsonElement)entry.getValue());
        }
    }

    public FabricIngredient<T> read(class_2540 buf) {
        CodecIngredient ingredient = (CodecIngredient)PacketHelper.readWithYabn(buf, this.serializer.network(), true).getOrThrow(false, arg_0 -> ((Logger)Constants.LOGGER).error(arg_0));
        return new FabricIngredient<CodecIngredient>(ingredient);
    }

    public void write(class_2540 buf, FabricIngredient<T> ingredient) {
        PacketHelper.writeWithYabn(buf, this.serializer.network(), ingredient.ingredient(), true).getOrThrow(false, s -> Constants.LOGGER.error("Could not parse {}", ingredient.ingredient()));
    }
}

